(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    190502,       5520]*)
(*NotebookOutlinePosition[    192699,       5586]*)
(*  CellTagsIndexPosition[    192595,       5579]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Estructura eucl\[IAcute]dea de ",
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]]],
  ". Curvas"
}], "Title"],

Cell[TextData[StyleBox["Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez\n\
Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author"],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell[TextData[{
  "Algunos temas de este curso los voy a presentar como cuadernos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "; de esta forma dispondremos de los recursos gr\[AAcute]ficos del programa \
para visualizar muchos de los conceptos que vamos a estudiar. Debe quedar \
claro desde ahora que lo que importa es el desarrollo te\[OAcute]rico de cada \
tema y que utilizo ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " como una herramienta para facilitar su estudio. Tu trabajo debe centrarse \
en el estudio y comprensi\[OAcute]n de los conceptos y definiciones y en la \
realizaci\[OAcute]n de los ejercicios que se proponen. No debes dedicar m\
\[AAcute]s tiempo del imprescindible a los comandos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que se definen; lo justo para saber usarlos para construir tus propios \
ejemplos pero no es preciso, ni es esa mi intenci\[OAcute]n, que comprendas \
bien los recursos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que utilizo, los cuales, por otra parte, pueden ser de utilidad para las \
clases de pr\[AAcute]cticas. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Estructura eucl\[IAcute]dea de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]]
}], "Section"],

Cell[TextData[{
  "Voy a recordarte algunas cosas que ya debes conocer. Como sabes, ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " es un espacio vectorial en el que suele destacarse la llamada ",
  StyleBox["base can\[OAcute]nica",
    FontSlant->"Italic"],
  " formada por los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`{\(e\_\(\(1\)\(,\)\)\) e\_2,  ... , e\_n}\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`e\_k\)]],
  " es el vector cuyas componentes son todas nulas excepto la que ocupa el \
lugar ",
  StyleBox["k",
    FontSlant->"Italic"],
  " que es igual a 1. En los libros de f\[IAcute]sica es frecuente poner \
flechas sobre las letras que representan vectores. Este proceder puede ser \
\[UAcute]til en algunos casos para evitar posibles confusiones pero, en \
general, no lo voy a seguir. Deber\[AAcute]s acostumbrarte a distinguir cu\
\[AAcute]ndo una letra representa un vector o un n\[UAcute]mero.\nDados dos \
vectores ",
  Cell[BoxData[
      \(TraditionalForm\`x = \((x\_1, x\_2,  ... , x\_n)\), \ 
      y = \((y\_1, y\_2,  ... , y\_n)\)\)]],
  " se define su producto escalar ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]x \[VerticalSeparator] 
          y\[RightAngleBracket]\)]],
  " por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[\(\[LeftAngleBracket]x | 
              y\[RightAngleBracket] = \(\[Sum]\+\(j = 1\)\%n\( x\_j\) 
                y\_j = \(\(x\_1\) y\_1 + \(x\_2\) y\_2 +  ... \) + \(x\_n\) 
                y\_n\)\),
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Este producto escalar se llama \"producto escalar eucl\[IAcute]deo\". \
Observa que el producto escalar de dos vectores no es un vector sino un n\
\[UAcute]mero real. La notaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", 
          StyleBox[".",
            FontWeight->"Bold"], "y"}], TraditionalForm]]],
  " es frecuentemente usada en los libros de F\[IAcute]sica para representar \
el producto escalar de los vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y. ",
    FontSlant->"Italic"],
  "Las dos notaciones son \[UAcute]tiles y las usaremos en lo que sigue con \
preferencia para la notaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]x | y\[RightAngleBracket]\)]],
  ".\nLas siguientes propiedades del producto escalar se deducen \
f\[AAcute]cilmente de la definici\[OAcute]n:\n",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]x | 
            y\[RightAngleBracket] = \[LeftAngleBracket]y | 
            x\[RightAngleBracket]\)]],
  "  para todos ",
  Cell[BoxData[
      \(TraditionalForm\`x, y, z \[Element] \[DoubleStruckCapitalR]\^n\)]],
  " (simetr\[IAcute]a).\n",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\[Alpha]\ x + \[Beta]\ y | 
            z\[RightAngleBracket] = \[Alpha] \[LeftAngleBracket]x | 
                z\[RightAngleBracket]\  + \ \[Beta] \[LeftAngleBracket]y | 
                z\[RightAngleBracket]\)]],
  "  para todos ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha], \[Beta] \[Element] \[DoubleStruckCapitalR]\
\)]],
  " y para todos ",
  Cell[BoxData[
      \(TraditionalForm\`x, y, z \[Element] \[DoubleStruckCapitalR]\^n\)]],
  " (linealidad).\n",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]x | x\[RightAngleBracket] > 
        0\)]],
  " siempre que ",
  Cell[BoxData[
      \(TraditionalForm\`x \[NotEqual] 0\)]],
  "\nLa norma eucl\[IAcute]dea de un vector se define por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[\(\(\(||\)\(x\)\(||\)\) = \(\@\[LeftAngleBracket]x | x\
\[RightAngleBracket] = \@\(\[Sum]\+\(j = 1\)\%n x\_j\%2\)\)\),
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En libros de f\[IAcute]sica es frecuente representar la norma \
eucl\[IAcute]dea por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["|",
            FontWeight->"Bold"], 
          StyleBox["x",
            FontWeight->"Plain"], 
          StyleBox["|",
            FontWeight->"Bold"]}], TraditionalForm]]],
  " y se le llama m\[OAcute]dulo o magnitud o longitud del vector ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". Tambi\[EAcute]n es  frecuente seguir el convenio de que una letra en \
negrita, por ejemplo ",
  StyleBox["v",
    FontWeight->"Bold"],
  ", representa un vector (digamos, la velocidad); y la misma letra pero en \
tipo normal, v, representa su norma (que ser\[IAcute]a la rapidez o \
celeridad). Ni que decir tiene que este convenio da lugar a \
much\[IAcute]simas confusiones. Advertido quedas."
}], "Text"],

Cell[TextData[{
  StyleBox["Desigualdad de Cauchy-Schwarz",
    FontWeight->"Bold"],
  ". Para todos ",
  Cell[BoxData[
      \(TraditionalForm\`x, y \[Element] \[DoubleStruckCapitalR]\^n\)]],
  "  se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`|\[LeftAngleBracket]x | y\[RightAngleBracket] | 
        \( \[LessEqual] \( || x || \  || y || \)\)\)]],
  ". Adem\[AAcute]s, supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " no son nulos, la igualdad ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(|\[LeftAngleBracket]x | y\[RightAngleBracket] | \) = 
        \( || x || \  || y || \)\)]],
  " equivale a que hay un n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] \[Element] \[DoubleStruckCapitalR]\)]],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`y = \[Lambda]\ x\)]],
  " (es decir, los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " est\[AAcute]n en una misma recta que pasa por el origen)."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Prueba la desigualdad de Cauchy-Schwarz.\nSugerencia. Comprueba que la \
ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]x - \[Lambda]\ y | 
            x - \[Lambda]\ y\[RightAngleBracket] = 0\)]],
  ", en la que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Lambda] \[Element] \[DoubleStruckCapitalR]\ 
      \)\)]],
  "es un n\[UAcute]mero real arbitrario y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ x, \ 
      y \[Element] \[DoubleStruckCapitalR]\^n\)\)]],
  " son vectores que se suponen fijos, es un trinomio de segundo grado en la \
variable \[Lambda]. Ten en cuenta que dicho trinomio toma siempre valores \
mayores o iguales que cero (\[DownQuestion]por qu\[EAcute]?) lo que \
proporciona informaci\[OAcute]n sobre su discriminante. "
}], "ExerciseText"],

Cell[TextData[{
  StyleBox["Desigualdad triangular",
    FontWeight->"Bold"],
  ". Para todos ",
  Cell[BoxData[
      \(TraditionalForm\`x, y \[Element] \[DoubleStruckCapitalR]\^n\)]],
  "  se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\( || x\  + \ y\) || 
        \( \[LessEqual] \( || x || \ \(+\ \( || y || \)\)\)\)\)]],
  ". Adem\[AAcute]s, supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " no son nulos, la igualdad ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || x + y\) || \) = \( || x || \ \(+\ \( || y || \)\)\)\)]],
  " equivale a que hay un n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] > 0\)]],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`y = \[Lambda]\ x\)]],
  " (es decir, los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " est\[AAcute]n en una misma ",
  StyleBox["semirecta",
    FontSlant->"Italic"],
  " que pasa por el origen)."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Prueba la desigualdad triangular.\nSugerencia. Una estrategia para probar \
desigualdades entre normas eucl\[IAcute]deas es elevar al cuadrado. La \
desigualdad ",
  Cell[BoxData[
      \(TraditionalForm
      \`\( || x\  + \ y\( || \^2\)\( \[LessEqual] 
          \(( || x || \ \(+\ \( || y || \)\))\)\^2\)\)\)]],
  " es equivalente a la desigualdad triangular pero es muy f\[AAcute]cil de \
probar desarrollando el t\[EAcute]rmino ",
  Cell[BoxData[
      \(TraditionalForm
      \`\( || x\  + \ y\( || \^2\)\) = 
        \[LeftAngleBracket]x + y | x + y\[RightAngleBracket]\)]],
  " y usando la desigualdad de Cauchy-Schwarz."
}], "ExerciseText"],

Cell[TextData[{
  StyleBox["Se dice que los vectores "],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[" e "],
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox[" son ortogonales, y escribimos "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(x \[UpTee] y\ \)\)]]],
  StyleBox["cuando su producto escalar es cero. Se dice que un vector "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`x\)]]],
  StyleBox[" es ortogonal a un conjunto de vectores "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`D \[Subset] \[DoubleStruckCapitalR]\^n\)]]],
  StyleBox[" cuando "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`x\)]]],
  StyleBox[" es ortogonal a todo vector en "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`D\)]]],
  StyleBox[
  ". Un conjunto de vectores no nulos que son mutuamente ortogonales se dice \
que es un "],
  StyleBox["conjunto ortogonal",
    FontWeight->"Bold"],
  StyleBox[
  " de vectores; si, adem\[AAcute]s, los vectores tienen todos norma 1 se \
dice que es un "],
  StyleBox["conjunto ortonormal",
    FontWeight->"Bold"],
  StyleBox[
  " de vectores. Una base vectorial que tambi\[EAcute]n es un conjunto \
ortogonal (ortonormal) se llama una base ortogonal (ortonormal). \nSi "],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[" e "],
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox[" son vectores no nulos, el vector"]
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[\(\(\[CapitalPi]\_y\) \((x)\) = \(\[LeftAngleBracket]x | 
                    y\[RightAngleBracket]\/\[LeftAngleBracket]y | 
                    y\[RightAngleBracket]\) y\)], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "se llama la ",
  StyleBox["proyeccci\[OAcute]n ortogonal de",
    FontWeight->"Bold"],
  StyleBox[" x",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" sobre ",
    FontWeight->"Bold"],
  StyleBox["y",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". ",
    FontSlant->"Italic"],
  "Puedes comprobar que el vector  ",
  Cell[BoxData[
      \(TraditionalForm\`x - \(\[CapitalPi]\_y\)(x)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "es ortogonal a ",
  StyleBox["y. ",
    FontSlant->"Italic"],
  "En particular, si ",
  StyleBox["y",
    FontSlant->"Italic"],
  " es un ",
  StyleBox["vector unitario",
    FontWeight->"Bold"],
  " (de norma 1) entonces el vector ",
  Cell[BoxData[
      \(TraditionalForm
      \`x\  - \ \[LeftAngleBracket]x\  | \ y\[RightAngleBracket] y\)]],
  " es ortogonal a ",
  StyleBox["y. ",
    FontSlant->"Italic"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "a) (",
  StyleBox["Teorema de Pit\[AAcute]goras",
    FontWeight->"Bold"],
  ") Prueba que los vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  " son ortogonales si, y solo si, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || x + y\)\( || \^2\)\) = 
        \( || x\( || \^2\)\(+\( || y\( || \^2\)\)\)\)\)]],
  ".\nb) Prueba que el vector  ",
  Cell[BoxData[
      \(TraditionalForm\`x - \(\[CapitalPi]\_y\)(x)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "es ortogonal a ",
  StyleBox["y.",
    FontSlant->"Italic"]
}], "ExerciseText"],

Cell[TextData[{
  "Es muy f\[AAcute]cil calcular las componentes de un vector en una base \
ortonormal. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`B = {u\_1, u\_2,  ... , u\_n}\)]],
  " una base ortonormal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " y sea ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \[DoubleStruckCapitalR]\^n\)]],
  ". Puedes comprobar que ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", "=", 
          RowBox[{
            FormBox[\(\[Sum]\+\(j = 1\)\%n\),
              
              "TraditionalForm"], \(\[LeftAngleBracket]x | 
                  u\_j\[RightAngleBracket] u\_j\)}]}], TraditionalForm]]],
  ", es decir, ",
  StyleBox["x",
    FontSlant->"Italic"],
  " es la suma de sus proyecciones ortogonales sobre los vectores de la base. \
Las componentes de ",
  StyleBox["x",
    FontSlant->"Italic"],
  " en dicha base son, por tanto,  ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[LeftAngleBracket]x | 
            u\_1\[RightAngleBracket], \[LeftAngleBracket]x | 
            u\_2\[RightAngleBracket], \(\(...\)\(\ \)\(\[LeftAngleBracket]x | 
              u\_n\[RightAngleBracket]\)\))\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["El producto escalar y la norma es invariante por cambios de base \
ortonormales",
    FontWeight->"Bold"],
  ". Es decir, si ",
  Cell[BoxData[
      \(TraditionalForm\`B = {u\_1, u\_2,  ... , u\_n}\)]],
  " es una base ortonormal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  "; ",
  Cell[BoxData[
      \(TraditionalForm\`x = \((x\_1, x\_2,  ... , x\_n)\), \ 
      y = \((y\_1, y\_2,  ... , y\_n)\)\)]],
  " son vectores de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " cuyas coordenadas en la base ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " son, respectivamente, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\((\[Alpha]\_1, \[Alpha]\_2,  ... , \[Alpha]\_n)\), "  ", 
          StyleBox["y",
            FontSlant->"Plain"], 
          "  ", \((\[Beta]\_1, \[Beta]\_2,  ... , \[Beta]\_n)\)}], 
        TraditionalForm]]],
  ", entonces se verifica que:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[LeftAngleBracket]x | 
          y\[RightAngleBracket] = \(\[Sum]\+\(j = 1\)\%n\( x\_j\) 
            y\_j = \[Sum]\+\(j = 1\)\%n\( \[Alpha]\_j\) \[Beta]\_j\)\)], \
"Text",
  TextAlignment->Center],

Cell["En particular,", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(||\)\(x\)\(||\)\) = \(\@\(\[Sum]\+\(j = 1\)\%n \
x\_j\%2\) = \@\(\[Sum]\+\(j = 1\)\%n \[Alpha]\_j\%2\)\)\)], "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Prueba las dos afirmaciones anteriores",
  StyleBox[".",
    FontSlant->"Italic"]
}], "ExerciseText"],

Cell[TextData[{
  "Dados dos vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", el n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\(\( || x - y\) || \)\)]],
  " se llama la distancia (eucl\[IAcute]dea) entre ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Supongamos ahora que H es un subespacio vectorial de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " y que ",
  Cell[BoxData[
      \(TraditionalForm\`{v\_1, v\_2,  ... , v\_k}\)]],
  " es una base ortonormal de H. Dado un vector ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \[DoubleStruckCapitalR]\^n\)]],
  ", el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\(P\_H\)(x)\), "=", 
          RowBox[{
            RowBox[{
              FormBox[\(\[Sum]\+\(j = 1\)\%k\),
                "TraditionalForm"], 
              \(\[LeftAngleBracket]x | v\_j\[RightAngleBracket] v\_j\)}], 
            "\[Element]", "H"}]}], TraditionalForm]]],
  " se llama la ",
  StyleBox["proyecci\[OAcute]n ortogonal de ",
    FontWeight->"Bold"],
  StyleBox["x",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" sobre H",
    FontWeight->"Bold"],
  ". Es inmediato que el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", "-", 
          FormBox[\(\(P\_H\)(x)\),
            "TraditionalForm"]}], TraditionalForm]]],
  " es ortogonal a cada uno de los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`v\_j, \ 1 \[LessEqual] j \[LessEqual] k\)]],
  " y, por la linealidad del producto escalar, deducimos que ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", "-", 
          FormBox[\(\(P\_H\)(x)\),
            "TraditionalForm"]}], TraditionalForm]]],
  " es ortogonal a ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["Distancia m\[IAcute]nima de un punto a un subespacio",
    FontWeight->"Bold"],
  StyleBox[". Vamos a probar que si ",
    FontWeight->"Plain"],
  StyleBox["H",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" es un subespacio vectorial de ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  StyleBox[", ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`{v\_1, v\_2,  ... , v\_k}\)],
    FontWeight->"Plain"],
  StyleBox[" es una base ortonormal de ",
    FontWeight->"Plain"],
  StyleBox["H",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["  y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  StyleBox[", se verifica que la distancia m\[IAcute]nima de ",
    FontWeight->"Plain"],
  StyleBox["x",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" al subespacio H es igual a ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{"||", 
          RowBox[{"x", "-", 
            FormBox[
              RowBox[{
                FormBox[\(\[Sum]\+\(j = 1\)\%k\),
                  
                  "TraditionalForm"], \(\[LeftAngleBracket]x | 
                      v\_j\[RightAngleBracket] v\_j\)}],
              "TraditionalForm"]}], "||"}], TraditionalForm]],
    FontWeight->"Plain"],
  StyleBox[".\n",
    FontWeight->"Plain"],
  StyleBox["Demostraci\[OAcute]n",
    FontWeight->"Bold"],
  StyleBox[". Llamemos ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{\(\(P\_H\)(x)\), "=", 
            RowBox[{
              FormBox[\(\[Sum]\+\(j = 1\)\%k\),
                
                "TraditionalForm"], \(\[LeftAngleBracket]x | 
                    v\_j\[RightAngleBracket] v\_j\)}]}],
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[". El vector ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\(P\_H\)(x)\)],
    FontWeight->"Plain"],
  StyleBox[" est\[AAcute] en ",
    FontWeight->"Plain"],
  StyleBox["H",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[". Queremos probar que ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(||\)\(x - \(P\_H\)(
                x)\)\(||\)\(\(\[LessEqual]\)\(\(\(||\)\(x - y\)\)\(||\)\)\)\),
          
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["para todo ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(y \[Element] H\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[". En efecto, para todo ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(y \[Element] H\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox["se tiene que el vector ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(P\_H\)(x) - y\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["tambi\[EAcute]n est\[AAcute] en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`H\)],
    FontWeight->"Plain"],
  " por lo que ",
  StyleBox["los vectores ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`x - \(P\_H\)(x)\)],
    FontWeight->"Plain"],
  " ",
  StyleBox["y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\(P\_H\)(x) - y\)],
    FontWeight->"Plain"],
  StyleBox[" son ortogonales y, usando el teorema de Pit\[AAcute]goras, \
deducimos que",
    FontWeight->"Plain"]
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              
              FormBox[\(\(\(\(||\)\(x - 
                        y\)\)\( || \^2\)\) = \(\(||\)\((\(x\)\(-\)\)\)\),
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  StyleBox[\(\(P\_H\)(x)\),
                    FontWeight->"Plain"],
                  "TraditionalForm"],
                "TraditionalForm"]}], ")"}], "+", 
          RowBox[{"(", 
            RowBox[{
              FormBox[
                FormBox[
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            StyleBox[\(P\_H\),
                              FontWeight->"Plain"], "(", 
                            StyleBox["x",
                              FontWeight->"Plain"], 
                            StyleBox[")",
                              FontWeight->"Plain"]}], "-", "y"}], 
                        ")"}], \( || \^2\)}], "="}],
                  "TraditionalForm"],
                "TraditionalForm"], " ", "||", 
              RowBox[{"x", "-", 
                RowBox[{
                  StyleBox[\(P\_H\),
                    FontWeight->"Plain"], "(", 
                  StyleBox["x",
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}]}], \( || \^2\), 
              RowBox[{"+", 
                RowBox[{"||", 
                  RowBox[{
                    RowBox[{
                      StyleBox[\(P\_H\),
                        FontWeight->"Plain"], "(", 
                      StyleBox["x",
                        FontWeight->"Plain"], 
                      StyleBox[")",
                        FontWeight->"Plain"]}], "-", "y"}], \( || \^2\), 
                  "  \t\t\t\t\t"}]}]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "esta igualdad implica que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(||\)\(x - \(P\_H\)(
              x)\)\)\( || \^2\)\(\(\[LessEqual]\)\(\(\(||\)\(x - 
                y\)\)\( || \^2\)\)\)\)]],
  ", es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(||\)\(x - \(P\_H\)(
              x)\)\) || \(\(\[LessEqual]\)\(\(\(||\)\(x - 
                y\)\)\(||\)\)\)\)]],
  "  y la igualdad se da solamente cuando ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(P\_H\)(x)\)]],
  ", es decir, que la distancia m\[IAcute]nima de ",
  StyleBox["x",
    FontSlant->"Italic"],
  " a ",
  StyleBox["H",
    FontSlant->"Italic"],
  " se alcanza solamente en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\(P\_H\)(x)\)]],
  "."
}], "Text"],

Cell[TextData[{
  " Cuando la dimensi\[OAcute]n de ",
  StyleBox["H",
    FontSlant->"Italic"],
  " es grande, puede calcularse f\[AAcute]cilmente el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(x - \(P\_H\)(x)\), "=", 
          RowBox[{"x", "-", 
            FormBox[
              RowBox[{
                FormBox[\(\[Sum]\+\(j = 1\)\%k\),
                  "TraditionalForm"], 
                \(\[LeftAngleBracket]x | v\_j\[RightAngleBracket] v\_j\)}],
              "TraditionalForm"]}]}], TraditionalForm]]],
  " de la siguiente forma: se ampl\[IAcute]a la base ",
  Cell[BoxData[
      \(TraditionalForm\`{v\_1, v\_2,  ... , v\_k}\)]],
  " a una base ortonormal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  "; sea esta ",
  Cell[BoxData[
      \(TraditionalForm
      \`B = {v\_1, v\_2,  ... , v\_k, \ u\_\(k + 1\),  ... , u\_n}\)]],
  ". De la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"x", "=", 
            RowBox[{
              RowBox[{
                FormBox[\(\[Sum]\+\(j = 1\)\%k\),
                  "TraditionalForm"], 
                \(\[LeftAngleBracket]x | v\_j\[RightAngleBracket] v\_j\)}], 
              "+", 
              RowBox[{
                FormBox[\(\[Sum]\+\(j = k + 1\)\%n\),
                  "TraditionalForm"], 
                \(\[LeftAngleBracket]x | u\_j\[RightAngleBracket] 
                  u\_j\)}]}]}]}], TraditionalForm]]],
  " se sigue que  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"x", "-", 
            FormBox[
              RowBox[{
                FormBox[\(\[Sum]\+\(j = 1\)\%k\),
                  "TraditionalForm"], 
                \(\[LeftAngleBracket]x | v\_j\[RightAngleBracket] v\_j\)}],
              "TraditionalForm"]}], "=", 
          RowBox[{
            FormBox[\(\[Sum]\+\(j = k + 1\)\%n\),
              "TraditionalForm"], 
            \(\[LeftAngleBracket]x | u\_j\[RightAngleBracket] u\_j\)}]}], 
        TraditionalForm]]],
  ". Este proceder es muy \[UAcute]til cuando ",
  Cell[BoxData[
      \(TraditionalForm\`k = n - 1\)]],
  " y permite calcular f\[AAcute]cilmente la distancia de un punto a un \
hiperplano (subespacio vectorial de dimensi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  "). Teniendo en cuenta que la distancia es invariante por traslaciones, \
este resultado te permite calcular (aunque no necesariamente por el camino m\
\[AAcute]s corto) la distancia de un punto a una recta o la distancia de un \
punto a un plano."
}], "Text"],

Cell[TextData[{
  "Acabamos de ver que es muy f\[AAcute]cil calcular la proyecci\[OAcute]n \
ortogonal de un vector sobre un subespacio si conocemos una base ortonormal \
del mismo. Por eso el siguiente procedimniento, conocido como ",
  StyleBox["procedimiento de ortogonalizaci\[OAcute]n de Gram-Schmidt ",
    FontSlant->"Italic"],
  "es de gran inter\[EAcute]s. Dicho procedimiento consiste en lo siguiente. \
Dada una base ",
  Cell[BoxData[
      \(TraditionalForm\`{v\_1, v\_2,  ... , v\_k}\)]],
  " de un subespacio vectorial ",
  StyleBox["H",
    FontSlant->"Italic"],
  ", queremos obtener a partir de ella otra base de ",
  StyleBox["H",
    FontSlant->"Italic"],
  " que sea ortonormal. Para ello definimos"
}], "Text"],

Cell[BoxData[{
    FormBox[
      RowBox[{
        RowBox[{\(u\_1 = v\_1\/\(\(||\)\(v\_1\)\(||\)\)\), ",", 
          "                  ", \(u\_2 = \(v\_2 - \[LeftAngleBracket]v\_2 | u\
\_1\[RightAngleBracket] u\_1\)\/\(\(||\)\(v\_2 - \[LeftAngleBracket]v\_2 | \
u\_1\[RightAngleBracket] u\_1\)\(||\)\)\), " ", ",", 
          
          FormBox[\(\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\(\(u\_3 = \(v\_3 - \
\[LeftAngleBracket]v\_3 | u\_2\[RightAngleBracket] u\_2 - \
\[LeftAngleBracket]v\_3 | u\_1\[RightAngleBracket] u\_1\)\/\(\(||\)\(v\_3 - \
\[LeftAngleBracket]v\_3 | u\_2\[RightAngleBracket] u\_2 - \
\[LeftAngleBracket]v\_3 | u\_1\[RightAngleBracket] u\_1\)\(||\)\)\)\(,\)\)\),
            "TextForm"]}], "\n"}], TraditionalForm], "\n", 
    FormBox[
      FormBox[\(u\_4 = \(v\_4 - \[LeftAngleBracket]v\_4 | u\_3\
\[RightAngleBracket] u\_3 - \[LeftAngleBracket]v\_4 | \
u\_2\[RightAngleBracket] u\_2 - \[LeftAngleBracket]v\_4 | u\_1\
\[RightAngleBracket] u\_1\)\/\(\(||\)\(v\_4 - \[LeftAngleBracket]v\_4 | u\_3\
\[RightAngleBracket] u\_3 - \[LeftAngleBracket]v\_4 | \
u\_2\[RightAngleBracket] u\_2 - \[LeftAngleBracket]v\_4 | u\_1\
\[RightAngleBracket] u\_1\)\(||\)\), \  ... \),
        "TextForm"], TraditionalForm]}], "Text",
  TextAlignment->Left],

Cell[TextData[{
  "Supuestos construidos ",
  Cell[BoxData[
      \(TraditionalForm\`u\_1, u\_2,  ... , \ u\_j\)]],
  " ortonormales dos a dos, se define ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(j + 1\)\)]],
  " como ",
  Cell[BoxData[
      \(TraditionalForm\`v\_\(j + 1\)\)]],
  " menos la proyecci\[OAcute]n ortogonal de ",
  Cell[BoxData[
      \(TraditionalForm\`v\_\(j + 1\)\)]],
  " sobre el subespacio engendrado por los vectores  ",
  Cell[BoxData[
      \(TraditionalForm\`u\_1, u\_2,  ... , \ u\_j\)]],
  " divididido por su norma,"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`u\_\(j + 1\) = \(v\_\(j + 1\) - \[Sum]\+\(i = 1\)\%j\
\[LeftAngleBracket]v\_\(j + 1\) | u\_\(\(\ \)\(i\)\)\[RightAngleBracket] \
u\_\(\(\ \)\(i\)\)\)\/\(\(\(\(||\)\(v\)\)\_\(j + 1\) - \[Sum]\+\(i = 1\)\%j\
\[LeftAngleBracket]v\_\(j + 1\) | u\_\(\(\ \)\(i\)\)\[RightAngleBracket] \
u\_\(\(\ \)\(i\)\)\)\(||\)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "con lo que obtenemos un vector unitario ortogonal a los vectores  ",
  Cell[BoxData[
      \(TraditionalForm\`u\_1, u\_2,  ... , \ u\_j\)]],
  " y, en consecuencia,  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            FormBox[\(u\_1, u\_2,  ... , \ u\_j\),
              "TraditionalForm"], ",", \(u\_\(j + 1\)\)}], "}"}], 
        TraditionalForm]]],
  " es un sistema ortonormal. Este proceso contin\[UAcute]a hasta agotar \
todos los vectores de la base dada. Observa que como los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            FormBox[\(u\_1, u\_2,  ... , \ \),
              "TraditionalForm"], \(u\_k\)}], "}"}], TraditionalForm]]],
  " dependen linealmente de los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          FormBox[\(v\_1, v\_2,  ... , \ v\_k\),
            "TraditionalForm"], "}"}], TraditionalForm]]],
  " el subespacio engendrado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            FormBox[\(u\_1, u\_2,  ... , \ \),
              "TraditionalForm"], \(u\_k\)}], "}"}], TraditionalForm]]],
  " es tambi\[EAcute]n ",
  StyleBox["H",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "El siguiente comando es un ejemplo de la potencia del lenguaje de \
programaci\[OAcute]n de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". En una sola l\[IAcute]nea se define un comando que realiza el proceso \
que acabamos de describir. Te recuerdo lo dicho: no trates de comprender la \
definici\[OAcute]n del comando. \[CapitalUAcute]salo como se indica en el \
ejemplo para ortonormalizar conjuntos de vectores que t\[UAcute] mismo debes \
definir y comprobar que efectivamente el resultado es un conjunto \
ortonormal."
}], "Text"],

Cell[BoxData[
    RowBox[{\( (*\ 
        autor : \ 
          Profesor\ Debra\ Lewis\ de\ la\ Universidad\ de\ California, \ 
        Berkeley\ *) \), "\[IndentingNewLine]", 
      StyleBox[\(gramschmidt = 
            Fold[Append[#1, \((#1\/\@\(#1 . #1\) &)\)[
                      Fold[#1 - #1 . #2\ #2\  &, #2, #1]]] &, {}, #1] &;\),
        FontFamily->"Courier New"]}]], "Input",
  FontFamily->"Courier New"],

Cell[TextData[{
  "Podemos aplicar este comando a vectores en cualquier dimensi\[OAcute]n (el \
comando ",
  Cell[BoxData[
      \(TraditionalForm\`Dot[x, y]\)]],
  " o ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", 
          StyleBox[".",
            FontWeight->"Bold"], "y"}], TraditionalForm]]],
  " calcula el producto escalar del vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " por el vector ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ")."
}], "Text"],

Cell[BoxData[{
    StyleBox[\(\(tr1 = 
        gramschmidt[{{1, 0, 2}, {0, 2, 3}, {1, 4, 0}}] // Simplify\)\( (*\ 
        aplicamos\ el\ proceso\ a\ los\ vectores\ {1, 0, 2}, {0, 2, 3}, {1, 
          4, 0}\ *) \)\),
      FontFamily->"Courier New"], "\n", 
    RowBox[{
      StyleBox[\(tr2 = 
          gramschmidt[{{1, 0, 2, 1}, {0, 2, 3, \(-1\)}, {\(-2\), 1, 4, 0}}] // 
            Simplify\),
        FontFamily->"Courier New"], 
      StyleBox[\( (*\ 
          aplicamos\ el\ proceso\ a\ los\ vectores\ {1, 0, 2, 1}, {0, 2, 
            3, \(-1\)}, {\(-2\), 1, 4, 0}\ *) \),
        FontFamily->"Courier New"], "\n", 
      StyleBox[\( (*\ 
          ahora\ comprobamos\ que\ los\ vectores\ obtenidos\ son\ \
ortonormales\ dos\ a\ dos\ *) \),
        FontFamily->"Courier New"]}], "\n", 
    StyleBox[\(\(\(Outer[Dot, tr1, tr1, 1] // Simplify\) // Chop\)\(\ \)\),
      FontFamily->"Courier New"], "\n", 
    StyleBox[\(\(\(Outer[Dot, tr2, tr2, 1] // Simplify\) // Chop\)\(\ \)\),
      FontFamily->"Courier New"], "\n", \(Clear[tr1, tr2]\)}], "Input",
  FontFamily->"Courier New"],

Cell[TextData[{
  "Supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`x \[NotEqual] 0, \ y \[NotEqual] 0\)]],
  ", la desigualdad de Cauchy-Schwarz puede escribirse en la forma:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(-1\) \[LessEqual] \[LeftAngleBracket]x | y\
\[RightAngleBracket]\/\(\(||\)\(x\)\(||\)\(\ \)\(||\)\(y\)\(||\)\) \
\[LessEqual] 1\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La medida en radianes del \[AAcute]ngulo que forman los vectores no nulos \
",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  " se define como el \[UAcute]nico n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] \([0, \[Pi]]\)\)]],
  " que verifica la igualdad"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`cos\ t = \[LeftAngleBracket]x | \
y\[RightAngleBracket]\/\(\(||\)\(x\)\(||\)\(\ \)\(||\)\(y\)\(||\)\)\)], "Text",\

  TextAlignment->Center],

Cell[TextData[{
  "Naturalmente, como consecuencia de esta definici\[OAcute]n, se verifica \
que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]x | y\[RightAngleBracket] = 
        \( || x ||  || y || cos\ t\)\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Particularizaci\[OAcute]n a ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]]
}], "Subsection"],

Cell[TextData[{
  "En f\[IAcute]sica se representan los vectores de la base can\[OAcute]nica \
de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "con las letras ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(i, \ j, \ k\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Es decir: "
}], "Text"],

Cell[TextData[{
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["i",
              FontWeight->"Bold"], "=", \((1, 0, 0)\)}], ",", " ", 
          RowBox[{
            StyleBox["j",
              FontWeight->"Bold"], "=", \((0, 1, 0)\)}], ",", " ", 
          RowBox[{
            StyleBox["k",
              FontWeight->"Bold"], "=", \((0, 0, 1)\)}]}], TraditionalForm]]]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Naturalmente, si ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " es un vector de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "se tiene que:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\((x, y, z)\), " ", "=", " ", 
        RowBox[{
          RowBox[{"x", " ", 
            StyleBox["i",
              FontWeight->"Bold"]}], "+", " ", 
          RowBox[{"y", " ", 
            StyleBox["j",
              FontWeight->"Bold"]}], "+", " ", 
          RowBox[{"z", " ", 
            StyleBox["k",
              FontWeight->"Bold"]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En Matem\[AAcute]ticas se prefiere la expresi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " y en f\[IAcute]sica se prefiere  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"x", " ", 
            StyleBox["i",
              FontWeight->"Bold"]}], "+", " ", 
          RowBox[{"y", " ", 
            StyleBox["j",
              FontWeight->"Bold"]}], "+", " ", 
          RowBox[{"z", " ", 
            StyleBox["k",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ". Debes tener bien claro que son dos formas de escribir lo mismo: el \
vector cuyas componentes en la base can\[OAcute]nica de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " son ",
  Cell[BoxData[
      \(TraditionalForm\`x, \ y, \ z\)]],
  ".\nEn ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "se define el ",
  StyleBox["producto vectorial",
    FontSlant->"Italic"],
  " de dos vectores ",
  Cell[BoxData[
      \(TraditionalForm\`x = \((x\_1, x\_2, x\_3)\), \ 
      y = \((y\_1, y\_2, y\_3)\)\)]],
  " como el vector:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(x\ \[Times]\ y\), "=", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              FormBox[
                RowBox[{"|", "\[NegativeThinSpace]", GridBox[{
                      {\(x\_2\), \(x\_3\)},
                      {\(y\_2\), \(y\_3\)}
                      }], "\[NegativeThinSpace]", "|"}],
                "TraditionalForm"], ",", 
              RowBox[{"-", " ", 
                RowBox[{"|", "\[NegativeThinSpace]", GridBox[{
                      {\(x\_1\), \(x\_3\)},
                      {\(y\_1\), \(y\_3\)}
                      }], "\[NegativeThinSpace]", "|"}]}], ",", 
              RowBox[{"|", "\[NegativeThinSpace]", GridBox[{
                    {\(x\_1\), \(x\_2\)},
                    {\(y\_1\), \(y\_2\)}
                    }], "\[NegativeThinSpace]", "|"}]}], " ", ")"}], " ", 
          "=", 
          RowBox[{
            RowBox[{\((\(x\_2\) y\_3 - \(x\_3\) y\_2)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", 
            RowBox[{\((\(x\_3\) y\_1 - \(x\_1\) y\_3)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\((\(x\_1\) y\_2 - \(x\_2\) y\_1)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell["\<\
No es imprescindible memorizar esta definici\[OAcute]n pues se verifica \
que:\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(x\ \[Times]\ y\), "=", 
        RowBox[{
          RowBox[{"determinante", " ", 
            RowBox[{"(", GridBox[{
                  {
                    StyleBox["i",
                      FontWeight->"Bold"], 
                    StyleBox["j",
                      FontWeight->"Bold"], 
                    StyleBox["k",
                      FontWeight->"Bold"]},
                  {\(x\_1\), \(x\_2\), \(x\_3\)},
                  {\(y\_1\), \(y\_2\), \(y\_3\)}
                  }], ")"}]}], "=", 
          RowBox[{
            RowBox[{\((\(x\_2\) y\_3 - \(x\_3\) y\_2)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((\(x\_3\) y\_1 - \(x\_1\) y\_3)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", " ", 
            RowBox[{\((\(x\_1\) y\_2 - \(x\_2\) y\_1)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Donde el determinante de la matriz se ha calculado formalmente \
considerando ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(i, \ j, \ k\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "como s\[IAcute]mbolos algebraicos. De aqu\[IAcute] se deduce que el \
producto vectorial ",
  Cell[BoxData[
      \(TraditionalForm\`x\[Times]y\)]],
  " es nulo cuando los vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  " son linealmente dependientes (suele decirse que son paralelos)."
}], "Text"],

Cell[TextData[{
  "Las siguientes propiedades del producto vectorial son f\[AAcute]ciles de \
comprobar.\n",
  Cell[BoxData[
      \(TraditionalForm\`x\[Times]y = \(-y\)\[Times]x\)]],
  " (es anticonmutativo)\n",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Alpha]\ x + \[Beta]\ y)\)\[Times]
          z = \[Alpha](x\[Times]y) + \[Beta](y\[Times]z)\)]],
  " (linealidad)\nUsando estas propiedades y sabiendo que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(i\[Times]i = \(j\[Times]j = \(k\[Times]k = 0\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(i\[Times]j = k\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(j\[Times]k = i\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(k\[Times]i = j\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", es f\[AAcute]cil calcular productos vectoriales. Una precauci\[OAcute]n \
que debes tener al trabajar con productos vectoriales es no usar la propiedad \
asociativa porque, en general, es falsa. Por ejemplo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["\[Times]",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            RowBox[{
              StyleBox["(",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox["\[Times]",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], 
                StyleBox["j",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], 
              StyleBox[")",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}], 
          StyleBox["=",
            FontWeight->"Bold"], 
          StyleBox[\(i\[Times]k = \(-j\)\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " pero ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\((i\[Times]i)\)\[Times]j = \(0\[Times]j = 0\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "Text"],

Cell["\<\
Vamos a calcular la norma eucl\[IAcute]dea del producto vectorial. Tenemos \
que:\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(\(\(\(||\)\(x\[Times]y\)\)\( || \^2\)\)\(=\)\),
              "TraditionalForm"], 
            
            FormBox[\(\(\((\(x\_2\) y\_3 - \(x\_3\) y\_2)\)\^2 + \((\(x\_3\) \
y\_1 - \(x\_1\) y\_3)\)\^2 + \ \((\(x\_1\) y\_2 - \(x\_2\) \
y\_1)\)\^2\)\(=\)\),
              
              "TraditionalForm"], \((x\_1\%2 + x\_2\%2 + 
                x\_3\%2)\), \((y\_1\%2 + y\_2\%2 + y\_3\%2)\)}], 
          "-", \(\((\(x\_1\) y\_1 + \(x\_2\) y\_2 + \(x\_3\) y\_3)\)\^2\)}], 
        "=", "\n", \(\(\(||\)\(x\)\( || \^2\)\(||\)\(y\)\( || \^2\)\(-\ \
\[LeftAngleBracket]x\  | \ y\[RightAngleBracket]\^2\)\) = \ \(\(\(||\)\(x\)\( \
|| \^2\)\(||\)\(y\)\( || \^2\)\(\ \)\(-\ \ \(\(||\)\(x\)\( || \
\^2\)\(||\)\(y\)\( || \^2\)\(\ \)\(\(cos\^2\)(
                    t)\)\)\)\) = \(\(||\)\(x\)\( || \^2\)\(||\)\(y\)\( || \^2\
\)\(\(sen\^2\)(t)\)\)\)\)}], TraditionalForm]]]], "Text"],

Cell[TextData[{
  "siendo ",
  StyleBox["t",
    FontSlant->"Italic"],
  " la medida en radianes del \[AAcute]ngulo que forman los vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y. ",
    FontSlant->"Italic"],
  "Como ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] \[Pi]\)]],
  ", se tiene que ",
  Cell[BoxData[
      \(TraditionalForm\`sen(t) \[GreaterEqual] 0\)]],
  ", y deducimos que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(||\)\(x\[Times]
              y\)\)\(||\)\) = \(\(||\)\(x\)\(||\)\(||\)\(y\)\(||\)\(sen(
            t)\)\)\)]],
  ". Realmente, hemos probado la bonita",
  StyleBox[" identidad de Lagrange",
    FontWeight->"Bold"],
  ": "
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      FrameBox[
        FormBox[
          RowBox[{\(\(||\)\(x\)\( || \^2\)\(||\)\(y\)\( || \^2\)\), "=", 
            RowBox[{
              RowBox[{
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{"x", 
                      StyleBox[".",
                        FontWeight->"Bold"], 
                      StyleBox["y",
                        FontWeight->"Plain"]}], 
                    StyleBox[")",
                      FontWeight->"Plain"]}], "2"], "+"}], 
              "||", \(x\[Times]y\), \( || \^2\)}]}],
          "TraditionalForm"]], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que relaciona la norma, el producto escalar y el producto vectorial. \
Podemos comprobar esta igualdad con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(X = {x\_1, x\_2, x\_3};\)\), "\n", 
    \(\(Y = {y\_1, y\_2, y\_3};\)\), "\n", 
    \(Simplify[
      X . X*Y . Y \[Equal] \((X . Y)\)^2 + 
          Cross[X, Y] . Cross[X, Y]]\)}], "Input"],

Cell[TextData[{
  "En algunos textos de f\[IAcute]sica se emplea la notaci\[OAcute]n ",
  StyleBox["x",
    FontSlant->"Italic"],
  "\[And]",
  StyleBox["y",
    FontSlant->"Italic"],
  " para representar el producto vectorial ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \[Times]\ y\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "Tambi\[EAcute]n usaremos de aqu\[IAcute] en adelante las letras ",
  StyleBox["i",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", ",
  StyleBox["j",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " para representar los vectores de la base can\[OAcute]nica de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  ", es decir, los vectores (1,0) y (0,1). El contexto indicar\[AAcute] \
claramente cu\[AAcute]ndo dichas letras representan vectores de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " o de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puedes calcular el producto escalar y el producto vectorial de dos \
vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  " con los comandos ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", 
          StyleBox[".",
            FontWeight->"Bold"], "y"}], TraditionalForm]]],
  " (o tambi\[EAcute]n Dot[x,y]) y Cross[x,y] respectivamente. \
Adem\[AAcute]s, podemos comprobar que el vector ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\ \[Times]\ y\ \ \ \)\)]],
  "es ortogonal a los vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  ".  Comprobamos tambi\[EAcute]n que el vector  ",
  Cell[BoxData[
      \(TraditionalForm\`x - \(\[CapitalPi]\_y\)(x)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "es ortogonal a ",
  StyleBox["y.",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[{
    \(\(X = {x\_1, x\_2, x\_3};\)\), "\n", 
    \(\(Y = {y\_1, y\_2, y\_3};\)\), "\n", 
    \(Cross[X, Y]\), "\n", 
    \(X . Cross[X, Y] // Simplify\), "\n", 
    \(Y . Cross[X, Y] // Simplify\), "\n", 
    \(\((X - \(X . Y\/Y . Y\) Y)\) . Y // Simplify\), "\n", 
    \(Clear[X, Y]\)}], "Input"],

Cell[TextData[{
  "En la definici\[OAcute]n de muchas magnitudes f\[IAcute]sicas intervienen \
el producto escalar o el producto vectorial. Los siguientes ejemplos son \
significativos.\n",
  StyleBox["Trabajo",
    FontWeight->"Bold"],
  ". El trabajo, ",
  StyleBox["W",
    FontSlant->"Italic"],
  ", realizado por una fuerza constante ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " (recuerda que la fuerza es un vector) al mover un objeto un \
desplazamiento ",
  StyleBox["d",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " (vector desplazamiento) viene dado por el producto escalar ",
  StyleBox["W",
    FontSlant->"Italic"],
  "=",
  StyleBox["F.d",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["Momento de una fuerza (par de torsi\[OAcute]n)",
    FontWeight->"Bold"],
  ". El momento, ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  ", tambi\[EAcute]n llamado par de torsi\[OAcute]n, de una fuerza ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " que act\[UAcute]a en un punto ",
  StyleBox["a",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "del espacio con vector de posici\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            FontWeight->"Bold"], "a"], TraditionalForm]]],
  " respecto de un punto ",
  StyleBox["b",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " con vector de posici\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            FontWeight->"Bold"], "b"], TraditionalForm]]],
  " est\[AAcute] dado por el producto vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["\[Tau]",
            FontWeight->"Bold"], "=", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                SubscriptBox[
                  StyleBox["r",
                    FontWeight->"Bold"], "a"], "-", 
                SubscriptBox[
                  StyleBox["r",
                    FontWeight->"Bold"], "b"]}], ")"}], "\[Times]", 
            StyleBox["F",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ".\n",
  StyleBox["Momento cin\[EAcute]tico (o momento angular)",
    FontWeight->"Bold"],
  ". Sea una part\[IAcute]cula de masa ",
  StyleBox["m",
    FontSlant->"Italic"],
  ", con una velocidad ",
  StyleBox["v",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " situada en un punto cuyo vector de posici\[OAcute]n es ",
  StyleBox["r",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". El momento cin\[EAcute]tico, ",
  StyleBox["L",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", (respecto al origen) de dicha part\[IAcute]cula se define como ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["L",
            FontWeight->"Bold"], "=", 
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "\[Times]", "m", " ", 
            StyleBox["v",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ".\n",
  StyleBox[
  "Fuerza magn\[EAcute]tica ejercida por un campo magn\[EAcute]tico sobre una \
carga",
    FontWeight->"Bold"],
  ". Una carga ",
  StyleBox["q",
    FontSlant->"Italic"],
  " que se mueve con velocidad ",
  StyleBox["v",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en un campo magn\[EAcute]tico constante ",
  StyleBox["B ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "experimenta una fuerza magn\[EAcute]tica, ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["F",
            FontWeight->"Bold"], "m"], TraditionalForm]]],
  ", dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["F",
              FontWeight->"Bold"], "m"], "=", 
          RowBox[{"q", " ", 
            StyleBox["v",
              FontWeight->"Bold"], "\[Times]", 
            StyleBox["B",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ". De hecho, esta igualdad se usa para ",
  StyleBox["definir",
    FontSlant->"Italic"],
  " el vector ",
  StyleBox["B",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " (que se llama tambi\[EAcute]n ",
  StyleBox["densidad de flujo magn\[EAcute]tico",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell["\<\
Con la primitiva gr\[AAcute]fica Arrow[base,extremo,opciones] puedes \
representar un vector en el plano que va del punto \"base\" al punto \
\"extremo\". Necesitamos cargar el correspondiente paquete.\
\>", "Text"],

Cell["<<Graphics`Arrow`", "Input",
  CellTags->"S5.32.1"],

Cell["\<\
Para usar colores con comodidad podemos cargar el paquete \"Colors\".\
\>", "Text"],

Cell["<<Graphics`Colors`", "Input",
  CellTags->"S5.32.1"],

Cell[BoxData[
    \(\(Show[
        Graphics[{Red, Arrow[{ .5, \(- .5\)}, {\(- .5\), 1.5}], Blue, 
            Arrow[{\(- .5\),  .5}, {1.5, \(- .5\)}]}, 
          AspectRatio -> Automatic, Axes -> True]];\)\)], "Input"],

Cell["Podemos modificar ese comando como sigue.", "Text"],

Cell[BoxData[
    \(\(\(vector2D[x_: {0, 0}, y_]\)\(:=\)\(Arrow[x, x + y]\)\(\ \)\( (*\ 
        traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x . \ 
              Por\ defecto\ x = {0, 0}*) \)\)\)], "Input"],

Cell[BoxData[
    \(\(Show[
        Graphics[{Green, vector2D[{ .2,  .4}], Blue, 
            vector2D[{ .2,  .2}, { .2,  .4}], Red, PointSize[0.02], 
            Point[{ .2,  .2}]}, Axes -> True, 
          AspectRatio -> Automatic]];\)\)], "Input"],

Cell[TextData[{
  "Las bases ortonormales en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " son de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`B = {\((a, b)\), \((\(-b\), a)\)}\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`a\^2 + b\^2 = 1\)]],
  ". En la siguiente firgura puedes ver la representaci\[OAcute]n de un \
vector de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " en una base ortonormal."
}], "Text"],

Cell[BoxData[{
    \(u = {\(-1\)\/\@2, 1\/\@2}; v = {\(-1\)\/\@2, \(-1\)\/\@2}; 
    x = {1, 2};\), "\n", 
    \(\(Show[
        Graphics[{Green, vector2D[u], Green, vector2D[v], Red, vector2D[x], 
            Blue, vector2D[\((x . u)\) u], vector2D[\((x . v)\) v]}, 
          Axes -> True, AspectRatio -> Automatic]];\)\)}], "Input"],

Cell["\<\
En la figura siguiente puedes ver, para el caso de dos dimensiones, una \
representaci\[OAcute]n gr\[AAcute]fica de la proyecci\[OAcute]n ortogonal de \
un vector sobre otro.\
\>", "Text"],

Cell[BoxData[{
    \(\(x = {0.6, 0.3};\)\), "\n", 
    \(\(y = {0.8, \(- .4\)};\)\), "\n", 
    \(w = \((x . y)\)*y/\((y . y)\)\ \ ; \  (*\ 
      proyecci\[OAcute]n\ ortogonal\ de\ x\ sobre\ y\ *) \n
    z = x - w\ \ ; \  (*\ es\ un\ vector\ ortogonal\ a\ y\ *) \n
    Show[Graphics[{Red, vector2D[x], vector2D[y], Blue, vector2D[w], Green, 
          vector2D[z], vector2D[w, z], Black, Text["\<z\>", z/2 + {0,  .1}], 
          Text["\<Tz\>", z/2 + {0,  .1} + w], Text["\<x\>", x/2 + {0,  .05}], 
          Text["\<y\>", 0.7*y - {0, 0.05}], Text["\<w\>", w/2 - {0,  .05}], 
          Text["\<O\>", {\(- .03\), \(- .03\)}], 
          Text["\<X\>", x + { .03,  .03}], Text["\<W\>", w - { .03,  .03}]}, 
        TextStyle -> {FontFamily -> "\<Times\>", \ FontSize -> 12}, 
        Axes -> True, AspectRatio -> Automatic, Ticks -> None]];\), "\n", 
    \(Print["\<w=(x.y)y/(y.y) es la proyeccci\[OAcute]n ortogonal de x sobre \
y \nz=x-w es un vector ortogonal a y\nTz es la traslaci\[OAcute]n del vector \
z alPunto W\nEl tri\[AAcute]ngulo OWX es rect\[AAcute]ngulo\nOberva que \
||z||=||Tz|| es la distancia del punto X a la recta vectorial\ngenerada por \
el vector y\>"]\), "\n", 
    \(z . y // Chop\  (*\ 
      el\ producto\ escalar\ de\ z\ por\ y\ es\ cero\ *) \), "\n", 
    \(Clear[x, y, w, z]\)}], "Input"],

Cell["\<\
Vamos a definir un comando para representar vectores en el espacio. \
Necesitamos algunos comandos previos que tienen su propio inter\[EAcute]s.\
\>", "Text"],

Cell[BoxData[
    \(\(\(norma[x_] := N[\@\(x . x\)]\  (*\ 
      norma\ eucl\[IAcute]dea\ del\ vector\ x\ *) \n
    \(\(normaliza[x_]\  := If[Simplify[x . x] == 0, x, \ x/norma[x]]; \  (*\ 
      vector\ unitario\ en\ la\ direcci\[OAcute]n\ del\ vector\ x\ *) \n
    normal3D[x_]\  := \ 
      normaliza[
        Which[x[\([1]\)] == 0, {1, 0, 
            0}, \((x[\([2]\)] \[NotEqual] 
                0)\) \[Or] \((x[\([3]\)] \[NotEqual] 0)\), {0, 
            x[\([3]\)], \(-x[\([2]\)]\)}, \((x[\([2]\)] == 0 \[And] 
              x[\([3]\)] == 0)\), {0, 1, 0}]]\)\(\n\)
    \)\)\( (*\ 
      un\ vector\ unitario\ ortogonal\ al\ vector\ x\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(arrow3D[x_, y_, color_:  RGBColor[0. , 0. , 0. ], 
          grosor_:  0.007] := \n\t\t\t{{color, Thickness[grosor], 
            Line[{x, y}]}, \n\ \ \ \ \ {SurfaceColor[
              color], \ \(Polygon[
                  Append[#, 
                    y]] &\)\  /@ \ \n\t\t\t\t\t\tPartition[\(\((y\ \  - \ 
                        0.18*\((y - x)\) + \ #)\) &\) /@ \((\((0.3*\ 0.18*
                          norma[y - x]*\ 
                          Table[{Cos[2\ k\ Pi/8. ], \ Sin[2\ k\ Pi/8. ]}, {k, 
                              0, 8}])\) . {normal3D[y - x], 
                        normaliza[Cross[normal3D[y - x], y - x]]})\), 2, 
                1]}};\)\n
    vector3D[x_List: {0, 0, 0}, y_List, color_:  RGBColor[0. , 0. , 0. ], 
        grosor_:  0.007] := arrow3D[x, x + y, color, grosor]\)\(\ \)\( (*\ 
      traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(Show[
        Graphics3D[{vector3D[{1, 2, 3}, Blue,  .02], 
            vector3D[{ .5,  .5,  .5}, {1, 2, 3}, Green,  .02]}, Axes -> True, 
          PlotRange -> All]];\)\)], "Input"],

Cell[TextData[{
  "En la figura siguiente puedes ver, para el caso de tres dimensiones, una \
representaci\[OAcute]n gr\[AAcute]fica de la proyecci\[OAcute]n ortogonal de \
un vector sobre otro y una interpretaci\[OAcute]n gr\[AAcute]fica del n\
\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(||\)\(x\[Times]
            y\)\(||\)\) = \(\(||\)\(x\)\(||\)\(||\)\(y\)\(||\)\(sen(
            t)\)\)\)]],
  " como el ",
  StyleBox["\[AAcute]rea del paralelogramo constru\[IAcute]do sobre los \
vectores",
    FontWeight->"Bold"],
  " ",
  StyleBox["x",
    FontSlant->"Italic"],
  " ",
  StyleBox["e",
    FontWeight->"Bold"],
  "  ",
  StyleBox["y",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[{
    \(\(x = {1, 1, 1};\)\), "\n", 
    \(\(y = 1.5 {\@1.5, \@1.5, 0};\)\), "\n", 
    \(\(w = \((x . y)\)*y/\((y . y)\)\ \ \  (*\ 
        proyecci\[OAcute]n\ ortogonal\ de\ x\ sobre\ y\ *) ;\)\), "\n", 
    \(z = x - w\ \ ; \  (*\ es\ un\ vector\ ortogonal\ a\ y\ *) \n
    Show[Graphics3D[{vector3D[x, Red], vector3D[y, Red], vector3D[w, Blue], 
          vector3D[z, Green], vector3D[w, z, Green], Line[{x, x + y}], 
          Line[{y, x + y}], Text["\<z\>", z/2 + {0,  .15, 0}], 
          Text["\<x\>", x/2 + {0,  .05, 0.18}], 
          Text["\<y\>", 0.7*y - {0, 0.05, 0.1}], 
          Text["\<w\>", w/2 - {0,  .05, 0.1}], 
          Text["\<Tz\>", w +  .5*z + { .15, 0, 0}], 
          Text["\<O\>", {\(- .03\), \(- .03\), \(- .15\)}], 
          Text["\<X\>", x + { .03,  .03, 0.15}], 
          Text["\<W\>", w - { .03,  .03, 0.2}], 
          Text["\<t\>", { .2,  .4, 0.02}]}, 
        TextStyle -> {FontFamily -> "\<Times\>", \ FontSize -> 12}, 
        Axes -> True, AspectRatio -> Automatic, Ticks -> None, 
        Epilog -> {Circle[{0. , 
                0.3},  .2, {\[Pi]/8 -  .09, \[Pi]/8 +  .18}], {Blue, 
              Thickness[0.007], 
              Line[{{0.08, 0.34}, {0.35, 0.386}}]}}]];\), "\n", 
    \(Print["\<w=(x.y)y/(y.y) es la proyeccci\[OAcute]n ortogonal de x sobre \
y \nz=x-w es un vector ortogonal a y\nTz es la traslaci\[OAcute]n del vector \
z al punto W\nEl tri\[AAcute]ngulo OWX es rect\[AAcute]ngulo\n\
||Tz||=||x||sen(t) (longitud de la hipotenusa por el seno del \[AAcute]ngulo \
opuesto)\nEl \[AAcute]rea del paralelogramo constru\[IAcute]do sobre los \
vectores x e y\nviene dada por ||x\[Times]y||=||y||||x||sen(t) (longitud de \
la base por la altura)\>"]\), "\n", 
    \(z . y // Chop\  (*\ 
      el\ producto\ escalar\ de\ z\ por\ y\ es\ cero\ *) \), "\n", 
    \(Clear[x, y, w, z]\)}], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "a) Calcula el \[AAcute]rea del paralelogramo de v\[EAcute]rtices (0,0,0), \
(5,0,0), (2,6,6), (7,6,6).\nb) Calcula el \[AAcute]rea del tri\[AAcute]ngulo \
de v\[EAcute]rtices (-1,1,2), (1,-1,3), (2,3,-1).\nc) Calcula el \[AAcute]rea \
del paralelogramo en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  "de v\[EAcute]rtices (0,1), (3,0), (5,-2), (2,-1)."
}], "ExerciseText"],

Cell["\<\
Es conveniente disponer de un comando para representar los ejes de \
coordenadas.\
\>", "Text"],

Cell[BoxData[
    \(ejes3D[u_, v_, w_:  0.006, color_:  Black]\  := \ \ {color, 
        Thickness[w], 
        Line[{{u, 0, 0}, {v, 0, 0}}], \n\ \ \ \ Line[{{0, u, 0}, {0, v, 0}}], 
        Line[{{0, 0, u}, {0, 0, v}}]}\)], "Input"],

Cell[BoxData[{
    \(\(u = {1,  .6,  .3};\)\), "\n", 
    \(\(v = {\(- .2\), \(- .3\), 1};\)\), "\n", 
    \(\(w = Cross[u, v];\)\), "\n", 
    \(\(graf = 
        Show[Graphics3D[{vector3D[u, Blue,  .01], 
              Text["\<u\>", u/2 + { .1,  .1,  .1}], vector3D[v, Red,  .01], 
              Text["\<v\>", v/2 + { .02,  .1,  .1}], 
              vector3D[w, Green,  .01], Text["\<w\>", w/2 + { .1,  .1,  .1}], 
              ejes3D[\(-0.4\), 1.5]}, Boxed -> False, 
            PlotRange -> All]];\)\), "\n", 
    \(Print["\<El producto vectorial w=u\[Times]v es ortogonal a u y a v\>"]\ \
\), "\n", 
    \(Clear[u, v, w]\)}], "Input"],

Cell["<<Graphics`Animation`", "Input",
  CellTags->"S5.29.1"],

Cell[BoxData[{
    \(SpinShow[graf]\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\), "\n", 
    \(Clear[graf]\)}], "Input"],

Cell[TextData[{
  "El producto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x . \((y\[Times]z)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se llama ",
  StyleBox["triple producto escalar",
    FontWeight->"Bold"],
  " de los vectores ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x, y, z\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". El volumen del paralelep\[IAcute]pedo determinado por los vectores ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x, y, z\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es igual a ",
  Cell[BoxData[
      FormBox[
        StyleBox[\( | x . \((y\[Times]z)\) | \),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Podemos comprobarlo gr\[AAcute]ficamente."
}], "Text"],

Cell[BoxData[{
    \(\(u = 1.5 {0.6, \(-0.3\), 1.2};\)\), "\n", 
    \(\(v = {1.5, 0.0, 0.0};\)\), "\n", 
    \(\(w = 1.5 {0.3, 1.2, 0.0};\)\), "\n", 
    \(\(vxw = Cross[v, w];\)\), "\n", 
    \(\[CapitalPi] = \((u . \((vxw)\)/vxw . vxw)\) vxw; \  (*\ 
      proyecci\[OAcute]n\ ortogonal\ de\ u\ sobre\ vxw\ *) \n
    Show[Graphics3D[{vector3D[u, Red,  .01], 
          Text["\<u\>", u/2 + {\(- .12\), 0, 0}], vector3D[v, Red,  .01], 
          Text["\<v\>", v/2 + {0,  .15, 0}], vector3D[w, Red,  .01], 
          Text["\<w\>", w/2 + {0, 0,  .15}], vector3D[vxw, Green,  .01], 
          Text["\<v\[Times]w\>",  .9  vxw + {\(- .3\), 0, 0}], 
          vector3D[\[CapitalPi], Blue,  .01], Line[{u, u + w, w}], 
          Text["\<\[CapitalPi]\>", \[CapitalPi]/2 + {\(- .2\), 0, 0}], 
          Line[{u, u + v, v}], Line[{w, v + w, v}], 
          Line[{v + w, u + v + w, u + v}], Line[{u + v + w, u + w}], 
          Line[{u, \[CapitalPi]}]}, Boxed -> False, PlotRange \[Rule] All, 
        TextStyle -> {FontFamily -> "\<Times\>", \ 
            FontSize -> 11}]];\), "\n", 
    \(Print["\<El volumen del paralelogramo determinado por los vectores u, v \
y w\nes igual al producto del \[AAcute]rea de la base por la altura.\nEl \
\[AAcute]rea de la base es igual a ||v\[Times]w||\nLa altura es igual a la \
norma del vector \[CapitalPi] que es\nla proyecci\[OAcute]n ortogonal del \
vector u sobre el vector v\[Times]w\n||\[CapitalPi]||=|u.(v\[Times]w)|/||v\
\[Times]w||\nPor tanto el volumen del paralelep\[IAcute]pedo es igual a |u.(v\
\[Times]w)|\>"]\ \), "\n", 
    \(Clear[u, v, w, vxw, \[CapitalPi]]\)}], "Input"],

Cell[TextData[{
  "La siguiente gr\[AAcute]fica ilustra la forma de calcular la distancia de \
un punto ",
  Cell[BoxData[
      \(TraditionalForm\`p = \((1, 2, 3)\)\)]],
  " al plano \[CapitalPi] engendrado por los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`x = \((1, 0, 1)\)\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y = \((1, 2, 0)\)\)]],
  " ."
}], "Text"],

Cell[BoxData[{
    \(\(x = {1, 0, 1};\)\), "\n", 
    \(y = {1, 2, 0};  (*\ 
      los\ vectores\ x\ e\ y\ son\ una\ base\ del\ plano\ \[CapitalPi]\ *) \n
    y = y - \((y . x/x . x)\)*x\ ;  (*\ vector\ ortogonal\ a\ x\ *) \n
    v1 = x/norma[x]; 
    v2 = y/norma[y];  (*\ {v1, 
          v2}\ es\ una\ base\ ortonormal\ del\ plano\ \[CapitalPi]\ *) \n
    p = {1, 2, 3};\), "\n", 
    \(\(w1 = \((p . v1)\)*v1\ \ \  (*\ 
        proyecci\[OAcute]n\ ortogonal\ de\ p\ sobre\ v1\ *) ;\)\), "\n", 
    \(\(w2 = \((p . v2)\)*v2\ \ \  (*\ 
        proyecci\[OAcute]n\ ortogonal\ de\ p\ sobre\ v2\ *) ;\)\), "\n", 
    \(z = p - w1 - w2\ \ ;  (*\ 
      es\ un\ vector\ ortogonal\ a\ v1\ y\ a\ v2\ y, \ 
      por\ tanto\ es\ ortogonal\ al\ plano\ \[CapitalPi]\ *) \n
    Show[Graphics3D[{vector3D[2  v1, Red], vector3D[2  v2, Red], 
          vector3D[p, Blue], 
          vector3D[z, Green], {Magenta, \ 
            Line[{v1, 3  v1, 3 \((v1 + v2)\), 3  v2, v2}]}, 
          vector3D[w1 + w2, z, Green], vector3D[w1 + w2, Cyan], 
          Text["\<v1\>", v1 - {0, 0, 1}], 
          Text["\<v2\>", v2 + {0,  .8, \(- .1\)}], 
          Text["\<p\>", p + {0,  .12,  .12}], 
          Text["\<z\>", z - {0, \(- .25\), 3}], 
          Text["\<w1+w2\>", w1 + w2 - {0,  .3,  .1}], 
          Text["\<\[CapitalPi]\>", w1 + w2 + {0,  .3, 1}], 
          Text["\<Tz\>", p - {0, \(-0.1\), 3}]}, AspectRatio -> Automatic, 
        Ticks -> None, Boxed -> False, PlotRange -> All, 
        ViewPoint -> {0.767, \ \(-0.731\), \ 3.214}, 
        TextStyle -> {FontFamily -> "\<Times\>", \ 
            FontSize -> 12}]];\), "\n", 
    \(Print["\<{v1,v2} es una base ortonormal de \[CapitalPi]\nw1+w2 es la \
proyecci\[OAcute]n ortogonal de p sobre el plano \[CapitalPi]\nz=p-w1-w2 es \
un vector ortogonal a \[Pi]\nTz se obtiene por traslaci\[OAcute]n de z\nLa \
distancia del punto p al plano \[Pi] es igual a ||Tz||=||z||= \>", 
      norma[z]]\ \), "\n", 
    \(\tClear[x, y, v1, v2, w1, w2, z, p]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "a) Calcula el volumen del paralelep\[IAcute]pedo determinado por los \
vectores ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, 0, 6)\), \ \((2, 3, \(-8\))\), \ 
      \((8, \(-5\), 6)\)\)]],
  ".\nb) Calcula el volumen del paralelep\[IAcute]pedo con aristas \
concurrentes ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(AB, \ AC, \ AD\),
          FontSlant->"Italic"], TraditionalForm]]],
  " siendo ",
  Cell[BoxData[
      \(TraditionalForm\`A = \((1, 1, 1)\), \ B = \ \((2, 0, 3)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`C = \((4, 1, 7)\), \ 
      D = \((3, \(-1\), \(-2\))\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "Prueba que la m\[IAcute]nima distancia de un punto ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((a, b, c)\)\)]],
  " al plano de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`A\ x + B\ y + C\ z + D = 0\)]],
  " es igual a "
}], "ExerciseText"],

Cell[BoxData[
    \(TraditionalForm\`\(\(|\)\(A\ a\  + \ B\ b\  + C\ c\  + \ D\)\(|\)\)\/\(\
\(||\)\((A, B, C)\)\(||\)\(\ \)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Sugerencia. Haz una traslaci\[OAcute]n. Ten en cuenta que el vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((A, B, C)\)\)]],
  " es ortogonal al plano."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Curvas en el plano", "Section"],

Cell[TextData[{
  "En todo lo que sigue consideraremos funciones de una o varias variables \
con derivada continua o con derivadas parciales de primer orden continuas \
respectivamente.\nUna curva \[CapitalGamma] en el plano puede venir dada de \
tres formas:\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " Como la gr\[AAcute]fica de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f : I \[Rule] \[DoubleStruckCapitalR]\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  " es un intervalo de \[DoubleStruckCapitalR]: ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalGamma] = {\((x, f(x))\) : 
            x \[Element] I}\)]],
  ".\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " De forma impl\[IAcute]cita como el conjunto de puntos donde se anula una \
funci\[OAcute]n de dos variables: ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              
              FormBox[\(\[CapitalGamma] = {\((x, 
                        y)\) \[Element] \[DoubleStruckCapitalR]\^2\),
                "TraditionalForm"], ":", \(g(x, y)\)}], "=", "0"}], "}"}], 
        TraditionalForm]]],
  ".\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " Por medio de ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] I\)]],
  " siendo ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  " un intervalo de \[DoubleStruckCapitalR]: ",
  Cell[BoxData[
      \(TraditionalForm\`\[CapitalGamma] = \(\[Gamma](
            I) = {\((x(t), y(t))\) : t \[Element] I}\)\)]],
  ".\nObserva que ",
  StyleBox["a)",
    FontWeight->"Bold"],
  " es un caso particular de ",
  StyleBox["b)",
    FontWeight->"Bold"],
  "  pues la gr\[AAcute]fica de una funci\[OAcute]n ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es el conjunto de puntos donde se anula la funci\[OAcute]n de dos \
variables ",
  Cell[BoxData[
      \(TraditionalForm\`g(x, y) = f(x) - y\)]],
  ", y tambi\[EAcute]n es un caso particular de ",
  StyleBox["c)",
    FontWeight->"Bold"],
  "  pues ",
  StyleBox["la gr\[AAcute]fica de una funci\[OAcute]n  ",
    FontWeight->"Bold"],
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["  tiene como ecuaciones param\[EAcute]tricas  ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](x) = \((x, f(x))\)\)],
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell[TextData[{
  "Para cada uno de estos casos ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene un comando que permite representar la curva dada:\n\
Plot[f[x],{x,a,b},opciones]  representa la gr\[AAcute]fica de la funci\
\[OAcute]n",
  StyleBox[" f ",
    FontSlant->"Italic"],
  "en el intervalo [a,b].\nImplicitPlot[g(x,y)==0,{x,a,b},opciones] \
representa la gr\[AAcute]fica de la curva ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                
                FormBox[
                  \({\((x, y)\) \[Element] \[DoubleStruckCapitalR]\^2\),
                  "TraditionalForm"], ":", \(g(x, y)\)}], "=", "0"}], ",", 
            " ", \(a \[LessEqual] x \[LessEqual] b\)}], "}"}], 
        TraditionalForm]]],
  ".\nParametricPlot[{x[t],y[t]},{t,a,b},opciones]  representa la \
gr\[AAcute]fica de la curva de ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  " para  ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] \([a, b]\)\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(f[x_] := \(1\/5\) Cos[x\^2] \[ExponentialE]\^Sin[2\ x]\), "\n", 
    \(\(graf1 = 
        Plot[f[x], {x, \(-2\), 3}, \n
          PlotRange -> {{\(-2.1\), 3.5}, {\(- .5\),  .5}}, \n
          AspectRatio -> Automatic, \nPlotStyle -> Thickness[ .004], \n\t
          Ticks -> None, ImageSize -> {407, \ 73}];\)\), "\n", 
    \( (*\ La\ gr\[AAcute]fica\ de\ una\ funci\[OAcute]n\ *) \)}], "Input"],

Cell[BoxData[
    \(\(\(<< \ Graphics`ImplicitPlot`\)\(\ \)\( (*\ 
      Hay\ que\ cargar\ este\ paquete\ para\ poder\ usar\ el\ comando\ *) \
\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(g[x_, y_] := x\^2\/9 + y\^2\/3 - 1\n
    \(\(graf2 = ImplicitPlot[g[x, y] == 0, {x, \(-3\), 3}];\)\(\n\)
    \)\)\( (*\ 
      Una\ curva\ definida\ impl\[IAcute]citamente\ *) \)\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"graf3", "=", 
          RowBox[{
            StyleBox["ParametricPlot",
              FontSize->12], 
            StyleBox["[",
              FontSize->12], 
            RowBox[{
              StyleBox[\({Cos[3  t/5], Sin[2  t/5]}\),
                FontSize->12], ",", \({t, 0, 10  Pi}\), ",", "\n", "\t\t", 
              StyleBox[\(AspectRatio -> Automatic\),
                FontSize->12]}], 
            StyleBox["]",
              FontSize->12]}]}], 
        StyleBox[" ",
          FontSize->12], 
        StyleBox[";",
          FontSize->12]}], 
      "\n", \( (*\ 
        Una\ curva\ definida\ por\ sus\ ecuaciones\ param\[EAcute]tricas\ *) \
\)}]], "Input"],

Cell["\<\
Las curvas planas m\[AAcute]s sencillas son las c\[OAcute]nicas que se \
definen como el conjunto de puntos donde se anula una funci\[OAcute]n polin\
\[OAcute]mica de grado dos con dos variables.\
\>", "Text"],

Cell[BoxData[
    \(\(\(ImplicitPlot[
        2\ x\ *y\  - \ x\^2 + y\^2 - 4 == 0, {x, \(-5\), 5}];\)\(\ \)\( (*\ 
      una\ hip\[EAcute]rbola\ *) \)\)\)], "Input"],

Cell[CellGroupData[{

Cell["Recta tangente en un punto de una curva plana", "Subsection"],

Cell["\<\
El c\[AAcute]lculo de la recta tangente depende de c\[OAcute]mo venga dada la \
curva. Consideremos los tres casos posibles.\
\>", "Text"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " La tangente en un punto",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\((a, 
          b)\) = \((a, f(a))\) \[Element] \[CapitalGamma]\)\)\)]],
  " es la recta de ecuaci\[OAcute]n cartesiana ",
  Cell[BoxData[
      \(TraditionalForm\`y - b = f\ ' \((a)\) \((x - a)\)\)]],
  ". El vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, f\ ' \((a)\))\)\)]],
  " es tangente a \[CapitalGamma] en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " y el vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((f\ ' \((a)\), \(-1\))\)\)]],
  " es ortogonal a \[CapitalGamma] en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  ".\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " La tangente en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\) \[Element] \[CapitalGamma]\)]],
  " es la recta de ecuaci\[OAcute]n impl\[IAcute]cita ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\[Del]\(g(a, 
                b)\) \[VerticalSeparator] \((x - a, 
              y - b)\)\[RightAngleBracket] = 0\)]],
  ". Se supone que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(g(a, b)\) \[NotEqual] \ \((0, 0)\)\)]],
  " pues en otro caso, la tangente en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " no est\[AAcute] definida. El vector gradiente ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(g(a, b)\)\)]],
  " es ortogonal a \[CapitalGamma] en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  ".\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " Supuesto que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{"\[Gamma]", 
                FormBox[\(\('\) \((t\_0\)\),
                  "TraditionalForm"]}], ")"}],
            "TraditionalForm"], "\[NotEqual]", \((0, 0)\)}], 
        TraditionalForm]]],
  ", la tangente a \[Gamma] en ",
  Cell[BoxData[
      \(TraditionalForm\`t\_0\)]],
  " (suele decirse, aunque no es del todo correcto, vector tangente a \
\[CapitalGamma] en el punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(\(\[Gamma]\)\((\)\(t\_0\)\),
              "TraditionalForm"], ")"}], ")"}], TraditionalForm]]],
  " es la recta de ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                FormBox[\(\((x, y)\) = \(\(\[Gamma]\)\((\)\(t\_0\)\)\),
                  "TraditionalForm"], ")"}], " ", "+", " ", 
              RowBox[{"t", " ", "\[Gamma]", 
                FormBox[\(\('\) \((t\_0\)\),
                  "TraditionalForm"]}]}], ")"}], " "}], TraditionalForm]]],
  ". El vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{"\[Gamma]", 
                FormBox[\(\('\) \((t\_0\)\),
                  "TraditionalForm"]}], ")"}],
            "TraditionalForm"], "=", 
          FormBox[
            RowBox[{
              RowBox[{
                FormBox[
                  RowBox[{
                    RowBox[{
                      FormBox[\((x' \((t\_0\)\),
                        "TraditionalForm"], ")"}], ",", \(y' \((t\_0\)\)}],
                  "TraditionalForm"], ")"}], ")"}],
            "TraditionalForm"]}], TraditionalForm]]],
  " es tangente a \[Gamma] en ",
  Cell[BoxData[
      \(TraditionalForm\`t\_0\)]],
  " (suele decirse, aunque no es del todo correcto, vector tangente a \
\[CapitalGamma] en ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(\(\[Gamma]\)\((\)\(t\_0\)\),
              "TraditionalForm"], ")"}], ")"}], TraditionalForm]]],
  ". En los puntos en los que el vector derivada es el vector cero no est\
\[AAcute] definida la tangente."
}], "Text"],

Cell["Las siguientes gr\[AAcute]ficas ilustran estos conceptos.", "Text"],

Cell[BoxData[{
    \(\(vectgnte1 = 
        Graphics[\n\t\tTable[{{Hue[ .65], 
                vector2D[{x, f[x]}, {1, \(f'\)[x]}]}, {Hue[0], 
                PointSize[ .012], Point[{x, f[x]}]}}, {x, \(-1.8\), 
              2.3,  .5}]\n\t\t\t\t\t];\)\), "\n", 
    \(\(Show[{graf1, vectgnte1}, ImageSize -> {407, \ 73}];\)\), "\n", 
    \(Clear[f, graf1, vectgnte1]\)}], "Input"],

Cell[BoxData[{
    \(\(gradg[x_, y_] = {D[g[x, y], x], D[g[x, y], y]};\)\), "\n", 
    \(puntos = 
      Union[graf2[\([1, 1, 1, 1, 1, 1]\)], 
        graf2[\([1, 1, 1, 2, 1, 1]\)]];  (*\ 
      as\[IAcute]\ obtengo\ una\ lista\ con\ los\ puntos\ de\ la\ \
gr\[AAcute]fica\ *) \n
    vectores = puntos /. {x_, y_} -> vector2D[{x, y}, gradg[x, y]];\n (*\ 
      vectores\ gradiente\ con\ base\ en\ los\ puntos\ *) \), "\n", 
    \(\(vectortgnal2 = 
        Graphics[\[IndentingNewLine]Table[{{Hue[ .65], 
                vectores[\([k]\)]}, {Hue[0], PointSize[ .015], 
                Point[puntos[\([k]\)]]}}, {k, 1, 
              Length[puntos]}]\[IndentingNewLine]\t\t\t\t\t];\)\), "\n", 
    \(\(Show[{graf2, vectortgnal2}];\)\), "\n", 
    \(Clear[graf2, puntos, vectores, vectortgnal2, g, gradg]\)}], "Input"],

Cell[BoxData[{
    RowBox[{
      RowBox[{
        RowBox[{\(\[Gamma][t_]\), "=", 
          StyleBox[\({Cos[3  t/5], Sin[2  t/5]}\),
            FontSize->12]}], 
        StyleBox[";",
          FontSize->12], 
        "\n", \(vectgnte3 = 
          Graphics[\n\t\tTable[{{Hue[ .65], 
                  vector2D[\[Gamma][t], \(\[Gamma]'\)[t]]}, {Hue[0], 
                  PointSize[ .015], Point[\[Gamma][t]]}}, {t, 0, 10  \[Pi], 
                2. }]\[IndentingNewLine]\t\t\t\t\t]\), ";"}], 
      "\t\t\t\t\t\t\t\t\t\t\t"}], "\n", \(Show[{graf3, 
          vectgnte3}];\)}], "Input"],

Cell[TextData[{
  "Podemos interpretar una curva ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  " como la trayectoria que recorre un m\[OAcute]vil cuyo vector de posici\
\[OAcute]n en el instante ",
  StyleBox["t",
    FontSlant->"Italic"],
  " viene dado por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  ". En tal caso, el vector derivada, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma]' \((t)\) = \((x' \((t)\), y' \((t)\))\)\)]],
  "  es la ",
  StyleBox["velocidad",
    FontWeight->"Bold"],
  " del m\[OAcute]vil en el instante ",
  StyleBox["t",
    FontSlant->"Italic"],
  " y la norma eucl\[IAcute]dea de dicho vector, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || \[Gamma]'\) \((t)\) || \) = 
        \@\(x' \((t)\)\^2 + y' \((t)\)\^2\)\)]],
  " es la ",
  StyleBox["rapidez",
    FontWeight->"Bold"],
  " o ",
  StyleBox["celeridad",
    FontWeight->"Bold"],
  " del m\[OAcute]vil en el instante ",
  StyleBox["t.",
    FontSlant->"Italic"],
  " La distancia recorrida por el m\[OAcute]vil desde el instante ",
  Cell[BoxData[
      \(TraditionalForm\`t = a\)]],
  " hasta el instante ",
  Cell[BoxData[
      \(TraditionalForm\`t = b\)]],
  " se obtiene, como es natural, integrando la rapidez y viene dada por ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_a\%b\(\( || \[Gamma]'\) \((t)\) || 
          \[DifferentialD]t\)\)]],
  ". Dicho de otra forma: la ",
  StyleBox["longitud de la curva",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] t \[LessEqual] b\)]],
  ", viene dada por ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_a\%b\(\( || \[Gamma]'\) \((t)\) || 
          \[DifferentialD]t\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Una curva ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  " se dice que es ",
  StyleBox["suave",
    FontWeight->"Bold"],
  " si tiene derivada ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma]' \((t)\) = \((x' \((t)\), y' \((t)\))\)\)]],
  " continua y que no se anula nunca. En tal caso se define el ",
  StyleBox["vector",
    FontWeight->"Bold"],
  " ",
  StyleBox["tangente unitario",
    FontWeight->"Bold"],
  " como"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["T",
            FontWeight->"Bold",
            FontSlant->"Italic"], \((t)\)}], "=", 
        \(\(\[Gamma]' \((t)\)\)\/\(\( || \[Gamma]' \((t)\) || \)\ \)\)}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Como ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]T(t)\  | \ T(t)\[RightAngleBracket] = 1\)]],
  ", se deduce que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]T' \((t)\)\  | \ T(t)\[RightAngleBracket] = 0\)]],
  ", es decir, supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`T' \((t)\) \[NotEqual] \((0, 0)\)\)]],
  ", el vector ",
  Cell[BoxData[
      \(TraditionalForm\`T' \((t)\)\)]],
  " es ortogonal al vector tangente. Se define por ello el ",
  StyleBox["vector normal unitario",
    FontWeight->"Bold"],
  " a la curva como "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["N",
            FontWeight->"Bold",
            FontSlant->"Italic"], \((t)\)}], "=", 
        FractionBox[
          RowBox[{
            StyleBox[\(T'\),
              FontWeight->"Bold",
              FontSlant->"Italic"], \((t)\)}], 
          RowBox[{
            RowBox[{"||", 
              RowBox[{
                StyleBox[\(T'\),
                  FontWeight->"Bold",
                  FontSlant->"Italic"], \((t)\)}], "||"}], " "}]]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell["Es f\[AAcute]cil definir comandos que calculen dichos vectores.", "Text"],

Cell[BoxData[{
    \(\(tgtunit[func_, 
          t_] = \(func'\)[t]\/\@\(\(func'\)[t] . \(func'\)[t]\);\)\), "\n", 
    \(normalunit[func_, t_] := 
      Module[{s}, normaliza[D[tgtunit[func, s], s]] /. s -> t]\)}], "Input"],

Cell[BoxData[{
    \(\(vectgnteunit = 
        Graphics[\n\t\tTable[{{Hue[ .65], 
                vector2D[\[Gamma][t], tgtunit[\[Gamma], t]]}, {Hue[0], 
                PointSize[ .015], Point[\[Gamma][t]]}}, {t, 0, 10  \[Pi], 
              5. }]];\)\), "\n", 
    \(\(vectnormalunit = 
        Graphics[\n\t\tTable[{Hue[ .25], 
              vector2D[\[Gamma][t], normalunit[\[Gamma], t]]}, {t, 0, 
              10  \[Pi], 5. }]];\)\), "\n", 
    \(\(Show[{graf3, vectgnteunit, vectnormalunit}];\)\), "\n", 
    \(Clear[graf3, vectgnteunit, vectnormalunit, vectgnte3]\)}], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell["\<\
Calcula las rectas tangente y normal a la elipse de ecuaci\[OAcute]n \
\>", "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            SuperscriptBox[
              StyleBox["x",
                FontWeight->"Bold",
                FontSlant->"Italic"], "2"], 
            RowBox[{
              SuperscriptBox[
                StyleBox["a",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], "2"], " "}]], 
          StyleBox["+",
            FontWeight->"Bold"], 
          FractionBox[
            SuperscriptBox[
              StyleBox["y",
                FontWeight->"Bold",
                FontSlant->"Italic"], "2"], 
            RowBox[{
              SuperscriptBox[
                StyleBox["b",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], "2"], " "}]]}], 
        StyleBox["=",
          FontWeight->"Bold"], "1"}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              StyleBox["a",
                FontWeight->"Bold"], ">", "0"}], ",", " ", 
            RowBox[{
              StyleBox["b",
                FontWeight->"Bold"], ">", "0"}]}], ")"}], TraditionalForm]]],
  " en un punto gen\[EAcute]rico (u,v) de la misma."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 9", "Exercise"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((t\^3 - t, t\^2 - t)\)\)]],
  ". Representa gr\[AAcute]ficamente la curva \[Gamma] para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-3\) \[LessEqual] t \[LessEqual] 3\)]],
  ". Calcula la recta tangente a \[Gamma] para ",
  Cell[BoxData[
      \(TraditionalForm\`t = 0\)]],
  " y para ",
  Cell[BoxData[
      \(TraditionalForm\`t = 1\)]],
  ". Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](0) = \(\[Gamma](1) = \((0, 0)\)\)\)]],
  ". Comprueba que \[Gamma] es una curva suave. Observa que la expresi\
\[OAcute]n \"tangente a \[Gamma] en (0,0)\" es ambigua porque la curva pasa \
dos veces por (0,0) y, en cada caso, lo hace con distinta velocidad."
}], "ExerciseText"],

Cell["\<\
El siguiente ejercicio pone de manifiesto que la forma geom\[EAcute]trica de \
una curva no proporciona informaci\[OAcute]n sobre la derivabilidad de la \
misma ni sobre su longitud. Lo importante de una curva es c\[OAcute]mo se \
recorre dicha curva, es decir, la funci\[OAcute]n que la define.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 10", "Exercise"],

Cell[TextData[{
  "a) Sea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((t, \( | t | \))\)\)]],
  ". Representa gr\[AAcute]ficamente la curva \[Gamma] para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] t \[LessEqual] 1\)]],
  ". Calcula la recta tangente a \[Gamma] para un valor ",
  Cell[BoxData[
      \(TraditionalForm\`t < 0\)]],
  " y para un valor ",
  Cell[BoxData[
      \(TraditionalForm\`t > 0\)]],
  ". \[DownQuestion]Es \[Gamma] derivable en ",
  Cell[BoxData[
      \(TraditionalForm\`t = 0\)]],
  "?\nb) Sea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((t\^3, t\^2 | t | )\)\)]],
  ". Representa gr\[AAcute]ficamente la curva \[Gamma] para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] t \[LessEqual] 1\)]],
  ". Calcula la recta tangente a \[Gamma] para un valor ",
  Cell[BoxData[
      \(TraditionalForm\`t < 0\)]],
  " y para un valor ",
  Cell[BoxData[
      \(TraditionalForm\`t > 0\)]],
  ". \[DownQuestion]Es \[Gamma] derivable en ",
  Cell[BoxData[
      \(TraditionalForm\`t = 0\)]],
  "? \[DownQuestion]Es \[Gamma] una curva suave?\nc) Sea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda](t) = \((cos\ 3  t, \ sen\ 3  t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ". Representa gr\[AAcute]ficamente las curva \[Gamma] y \[Lambda]. Calcula \
el vector derivada y la rapidez de cada curva. Calcula la longitud de \
\[Gamma] y la de \[Lambda].\nd) Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[\(\[Gamma](t) = \((cos\^3\)\),
                "TraditionalForm"], "t"}], ",", " ", 
            RowBox[{
              FormBox[\(sen\^3\),
                "TraditionalForm"], "t"}]}], ")"}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ". Representa gr\[AAcute]ficamente la curva \[Gamma]. \[DownQuestion]Tiene \
\[Gamma] derivada continua? \[DownQuestion]Es \[Gamma] una curva suave? \
Calcula la longitud de \[Gamma]."
}], "ExerciseText"],

Cell[TextData[{
  "Si ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y)\)]],
  " es un campo escalar de dos variables, las curvas de ecuaci\[OAcute]n impl\
\[IAcute]cita ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = c\)]],
  " o, lo que es igual ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) - c = 0\)]],
  ", donde ",
  StyleBox["c",
    FontSlant->"Italic"],
  " es una constante, se llaman ",
  StyleBox["curvas de nivel",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". De lo dicho antes, se sigue que ",
  StyleBox["el vector gradiente ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Del]\)\(f(x, y)\)\(\ \)\)\)],
    FontWeight->"Bold"],
  StyleBox["es ortogonal en todo punto ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)],
    FontWeight->"Bold"],
  StyleBox[" (en el que ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f(x, y)\) \[NotEqual] \((0, 0)\)\)],
    FontWeight->"Bold"],
  StyleBox[") a la curva de nivel que pasa por dicho punto",
    FontWeight->"Bold"],
  ". Podemos representar varias curvas de nivel de una funci\[OAcute]n usando \
el comando"
}], "Text"],

Cell["\"ContourPlot[f[x,y],{x,xmin,xmax},{y,ymin,ymax},opciones]\"", "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que representa curvas de nivel, ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = c\)]],
  ", para una sucesi\[OAcute]n de valores de ",
  StyleBox["c",
    FontSlant->"Italic"],
  " igualmente espaciados. Con la opci\[OAcute]n \"Contours\[Rule]{valores}\" \
puedes especificar para qu\[EAcute] valores de ",
  StyleBox["c",
    FontSlant->"Italic"],
  " quieres que se representen las curvas de nivel ."
}], "Text"],

Cell[BoxData[
    \(\(ContourPlot[x^2/4 + y^2/9, {x, \(-2\), 2}, {y, \(-3\), 3}, 
        Contours -> Table[c, {c,  .1, 1,  .2}], AspectRatio -> Automatic, 
        ContourShading -> False, PlotPoints -> 25, Axes -> True, 
        AxesOrigin -> {0, 0}, Frame -> False];\)\)], "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Curvas param\[EAcute]tricas en el espacio. Velocidad, aceleraci\[OAcute]n, \
curvatura.\
\>", "Section"],

Cell[TextData[{
  "Las definiciones que hemos dado antes para curvas param\[EAcute]trica en \
el plano pueden generalizarse sin esfuerzo a curvas param\[EAcute]tricas en ",
  
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  ". Como en las aplicaciones f\[IAcute]sicas el caso ",
  Cell[BoxData[
      \(TraditionalForm\`n = 3\)]],
  " tiene especial importancia, consideraremos en lo que sigue curvas en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " aunque la mayor\[IAcute]a de los conceptos que vamos a estudiar se \
generalizan f\[AAcute]cilmente a ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  ". \nPor definici\[OAcute]n, una curva en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " es una aplicaci\[OAcute]n continua ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma] : \([a, b]\)\), "\[Rule]", 
          FormBox[\(\[DoubleStruckCapitalR]\^3\),
            "TraditionalForm"]}], TraditionalForm]]],
  ". La funci\[OAcute]n \[Gamma] debe ser de la forma"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\[Gamma](t)\), "=", 
        RowBox[{\((x(t), y(t), z(t))\), "=", 
          RowBox[{
            RowBox[{\(x(t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(y(t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(z(t)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En lo que sigue supondremos que las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`x(t), \ y(t), \ z(t)\)]],
  " son derivables con derivada continua en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  ". El punto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](a)\)]],
  " se llama punto inicial de la curva u origen y el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](b)\)]],
  " se llama punto final o extremo. Cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](a) = \[Gamma](b)\)]],
  " se dice que la curva es cerrada. Una curva se dice que es ",
  StyleBox["simple",
    FontWeight->"Bold"],
  " si pasa una sola vez por cada uno de sus puntos, es decir si no se corta \
a s\[IAcute] misma o, lo que es igual, la funci\[OAcute]n \[Gamma] es \
inyectiva en ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  ", o sea,",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \[Gamma](u) \[NotEqual] \[Gamma](v)\)\)]],
  " siempre que ",
  Cell[BoxData[
      \(TraditionalForm\`u, v \[Element] \([a, b]\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`u \[NotEqual] v\)]],
  ". Una curva cerrada se dice que es simple si \[Gamma] es inyectiva en",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \([a, \(b[\)\)\)\)]],
  ". Una curva cerrada y simple se llama una curva de Jordan."
}], "Text"],

Cell[TextData[{
  "El comando ParametricPlot3D[{X[t],Y[t],Z[t]},{t,tmin,tmax},opciones] sirve \
para representar curvas en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " dadas por sus ecuaciones param\[EAcute]tricas. ",
  "Si a\[NTilde]ades al final una funci\[OAcute]n de color, como en el \
siguiente ejemplo donde se usa la funci\[OAcute]n de color \"Hue[ ]\", los \
puntos de la curva se colorean variando los colores de forma continua. Tambi\
\[EAcute]n puedes controlar el grosor de la l\[IAcute]nea con \"Thickness[ \
]\"."
}], "Text"],

Cell[BoxData[
    \(\(\(helice = 
      ParametricPlot3D[{3  Cos[t], 3  Sin[t], 
          t, {Hue[t/3  \[Pi]], Thickness[ .01]}}, {t, 0, 3  \[Pi]}, 
        Ticks \[Rule] None]\)\(;\)\( (*\ 
      una\ h\[EAcute]lice\ circular\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Podemos interpretar una curva ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t), \ z(t))\)\)]],
  " como la trayectoria en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "que recorre un m\[OAcute]vil cuyo vector de posici\[OAcute]n en el \
instante ",
  StyleBox["t",
    FontSlant->"Italic"],
  " viene dado por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t), \ z(t))\)\)]],
  ". Se dice entonces que \[Gamma] es la ",
  StyleBox["funci\[OAcute]n de trayectoria",
    FontWeight->"Bold"],
  " del m\[OAcute]vil. En tal caso, el vector derivada, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma]' \((t)\) = \((x' \((t)\), y' \((t)\), \ z' \((t)\))\)\)]],
  "  es la ",
  StyleBox["velocidad",
    FontWeight->"Bold"],
  " del m\[OAcute]vil en el instante ",
  StyleBox["t",
    FontSlant->"Italic"],
  " y la norma eucl\[IAcute]dea de dicho vector, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || \[Gamma]'\) \((t)\) || \) = 
        \@\(x' \((t)\)\^2 + y' \((t)\)\^2 + z' \((t)\)\^2\)\)]],
  " es la ",
  StyleBox["rapidez",
    FontWeight->"Bold"],
  " o ",
  StyleBox["celeridad",
    FontWeight->"Bold"],
  " del m\[OAcute]vil en el instante ",
  StyleBox["t. ",
    FontSlant->"Italic"],
  "Debes tener clara la diferencia entre estos conceptos."
}], "Text"],

Cell[TextData[{
  "Una curva ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t), \ z(t))\)\)]],
  " se dice que es ",
  StyleBox["suave",
    FontWeight->"Bold"],
  " si tiene derivada ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma]' \((t)\) = \((x' \((t)\), y' \((t)\), \ z' \((t)\))\)\)]],
  " continua y que no se anula nunca. En tal caso se define el ",
  StyleBox["vector tangente unitario",
    FontWeight->"Bold"],
  " como"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["T",
            FontWeight->"Bold",
            FontSlant->"Italic"], \((t)\)}], "=", 
        \(\(\[Gamma]' \((t)\)\)\/\(\( || \[Gamma]' \((t)\) || \)\ \)\)}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Como ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold"], "(", "t", ")"}], " ", "|", " ", 
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold"], "(", "t", ")"}]}], 
            "\[RightAngleBracket]"}], "=", "1"}], TraditionalForm]]],
  ", se deduce que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["T",
                    FontWeight->"Bold"], " ", "'"}], \((t)\)}], " ", "|", 
              " ", 
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold"], "(", "t", ")"}]}], 
            "\[RightAngleBracket]"}], "=", "0"}], TraditionalForm]]],
  ", es decir, supuesto que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], " ", "'"}], \((t)\)}], "\[NotEqual]", 
          \((0, 0, 0)\)}], TraditionalForm]]],
  ", el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["T",
              FontWeight->"Bold"], " ", "'"}], \((t)\)}], TraditionalForm]]],
  " es ortogonal al vector tangente. "
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 11", "Exercise"],

Cell[TextData[{
  "Justifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]T\ ' \((t)\)\  | \ T(t)\[RightAngleBracket] = 0
        \)]],
  "."
}], "ExerciseText"],

Cell[TextData[{
  "Se define por ello el vector ",
  StyleBox["normal principal unitario",
    FontWeight->"Bold"],
  " a la curva como "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["N",
            FontWeight->"Bold",
            FontSlant->"Italic"], \((t)\)}], "=", 
        FractionBox[
          RowBox[{
            StyleBox[\(T'\),
              FontWeight->"Bold",
              FontSlant->"Italic"], \((t)\)}], 
          RowBox[{
            RowBox[{"||", 
              RowBox[{
                StyleBox[\(T'\),
                  FontWeight->"Bold",
                  FontSlant->"Italic"], \((t)\)}], "||"}], " "}]]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observa que los comandos que antes hemos definido \"tgtunit[ ]\" y \
\"normalunit[ ]\" podemos usarlos tambi\[EAcute]n para curvas en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ".  "
}], "Text"],

Cell[TextData[{
  "Se define el ",
  StyleBox["vector binormal",
    FontWeight->"Bold"],
  " como el producto vectorial del vector tangente unitario por el vector \
normal principal unitario "
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["B",
            FontWeight->"Bold"], 
          StyleBox["(",
            FontWeight->"Plain"], 
          StyleBox["t",
            FontWeight->"Plain"], 
          StyleBox[")",
            FontWeight->"Plain"]}], 
        StyleBox["=",
          FontWeight->"Bold"], 
        RowBox[{
          RowBox[{
            StyleBox["T",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["t",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], 
          StyleBox["\[Times]",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox["N",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["t",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es claro, por las definiciones dadas, que, cualquiera sea ",
  StyleBox["t",
    FontSlant->"Italic"],
  ", el sistema ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["{",
            FontWeight->"Bold"], 
          RowBox[{
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox["t",
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], 
            StyleBox[",",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox["N",
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox["t",
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}], 
            StyleBox[",",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox["B",
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox["t",
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}]}], 
          StyleBox["}",
            FontWeight->"Bold"]}], TraditionalForm]]],
  " es una base ortonormal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " que se llama el ",
  StyleBox["triedro intr\[IAcute]nseco",
    FontWeight->"Bold"],
  " de la curva \[Gamma]. Podemos visualizarlo (multiplicamos por 2 los \
vectores de la base para verlos mejor)."
}], "Text"],

Cell[BoxData[{
    \(\(\[Gamma][t_] := {3  Cos[t], 3  Sin[t], t};\)\), "\n", 
    \(\(vectgnteunit = 
        Graphics3D[\n\t\tTable[{{vector3D[\[Gamma][t], 
                  2  tgtunit[\[Gamma], t]]}, {Red, PointSize[ .02], 
                Point[\[Gamma][t]]}}, {t, 0, 3  \[Pi], 
              N[\[Pi]/2]}]];\)\), "\n", 
    \(\(vectnormalunit = 
        Graphics3D[\n\t\tTable[{vector3D[\[Gamma][t], 
                2  normalunit[\[Gamma], t]]}, {t, 0, 3  \[Pi], 
              N[\[Pi]/2]}]];\)\), "\n", 
    \(\(binormalunit = 
        Graphics3D[\n\t\tTable[{vector3D[\[Gamma][t], 
                2  Cross[tgtunit[\[Gamma], t], 
                    normalunit[\[Gamma], t]]]}, {t, 0, 3  \[Pi], 
              N[\[Pi]/2]}]];\)\), "\n", 
    \(\(Show[{helice, vectgnteunit, vectnormalunit, 
          binormalunit}];\)\), "\n", 
    \(Print["\<En la gr\[AAcute]fica se ha representado la base \
{T(t),N(t),B(t)} para distintos \nvalores de t traslad\[AAcute]ndola al punto \
correspondiente de la curva.\>"]\), "\n", 
    \(Clear[\[Gamma], helice, vectgnteunit, vectnormalunit, 
      binormalunit]\)}], "Input"],

Cell[TextData[{
  "La distancia recorrida por el m\[OAcute]vil desde el instante ",
  Cell[BoxData[
      \(TraditionalForm\`t = a\)]],
  " hasta el instante ",
  Cell[BoxData[
      \(TraditionalForm\`t = b\)]],
  " se obtiene, como es natural, integrando la rapidez y viene dada por ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_a\%b\(\( || \[Gamma]'\) \((t)\) || 
          \[DifferentialD]t\)\)]],
  ". Dicho de otra forma: la ",
  StyleBox["longitud de la curva",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t), z(t))\)\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] t \[LessEqual] b\)]],
  ", viene dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[Integral]", 
              StyleBox["a",
                FontSlant->"Italic"], 
              StyleBox["b",
                FontSlant->"Italic"]], \(\( || \[Gamma]'\) \((t)\)\)}], "||", 
          \(\[DifferentialD]t\)}], "=", 
        FormBox[
          \(\[Integral]\_a\%b
              \(\@\( x' \((t)\)\^2 + y' \((t)\)\^2 + z' \((t)\)\^2\)\) 
              \[DifferentialD]t\),
          "TraditionalForm"]}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`s : \([a, b]\) \[Rule] \[DoubleStruckCapitalR]\)]],
  " definida para todo ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] \([a, b]\)\)]],
  " por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(s(t)\),
          FontSlant->"Italic"], "=", 
        RowBox[{
          RowBox[{
            SubsuperscriptBox["\[Integral]", 
              StyleBox["a",
                FontSlant->"Italic"], 
              StyleBox["t",
                
                FontSlant->
                  "Italic"]], \(\(||\)\(\[Gamma]' \((u)\)\)\(||\)\(\
\[DifferentialD]u\)\)}], "=", 
          
          FormBox[\(\[Integral]\_a\%t\(\@\( x' \((u)\)\^2 + y' \((u)\)\^2 + 
                      z' \((u)\)\^2\)\) \[DifferentialD]u\),
            "TraditionalForm"]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "se llama funci\[OAcute]n ",
  StyleBox["longitud de arco",
    FontWeight->"Bold"],
  " y nos da la distancia recorrida por el m\[OAcute]vil hasta el instante ",
  StyleBox["t. ",
    FontSlant->"Italic"],
  "Por su definici\[OAcute]n, es claro que ",
  Cell[BoxData[
      \(TraditionalForm\`s(t)\)]],
  " es una primitiva de ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(\(||\)\(\[Gamma]'\)\) \((t)\)\)\(||\)\)\)]],
  ", es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`s' \((t)\) = \(\(\(\(||\)\(\[Gamma]'\)\) \
\((t)\)\)\(||\)\)\)]],
  ". Observa que la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(s' \((t)\)\), "=", 
          FormBox[\(\@\(x' \((t)\)\^2 + y' \((t)\)\^2 + z' \((t)\)\^2\)\),
            "TraditionalForm"]}], TraditionalForm]]],
  " tiene una intrepretaci\[OAcute]n f\[IAcute]sica clara: la derivada del \
espacio recorrido respecto al tiempo es la rapidez. Esta igualdad suele \
expresarse en la forma "
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\[DifferentialD]s\), "=", 
        FormBox[
          \(\@\(\[DifferentialD]x\^2 + \[DifferentialD]y\^2 + 
                \[DifferentialD]z\^2\)\),
          "TraditionalForm"]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "y a ",
  Cell[BoxData[
      \(TraditionalForm\`\[DifferentialD]s\)]],
  " se le llama ",
  StyleBox["elemento",
    FontWeight->"Bold"],
  " ",
  StyleBox["diferencial de longitud de arco",
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell[TextData[{
  "Se define la ",
  StyleBox["aceleraci\[OAcute]n ",
    FontWeight->"Bold"],
  "como la derivada de la velocidad, es decir, la derivada segunda, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\[Gamma]'\)' \((t)\) = 
        \((\(x'\)' \((t)\), \(y'\)' \((t)\), \(z'\)' \((t)\))\)\)]],
  ", de la funci\[OAcute]n de trayectoria. En f\[IAcute]sica son frecuentes \
las siguientes notaciones:\n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["r",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " para representar la funci\[OAcute]n de trayectoria que hemos representado \
por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t)\)]],
  "; ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{\((x(t), y(t), z(t))\), "=", 
            RowBox[{
              RowBox[{\(x(t)\), 
                StyleBox["i",
                  FontWeight->"Bold"]}], "+", 
              RowBox[{\(y(t)\), 
                StyleBox["j",
                  FontWeight->"Bold"]}], "+", 
              RowBox[{\(z(t)\), 
                StyleBox["k",
                  FontWeight->"Bold"]}]}]}]}], TraditionalForm]]],
  " (es un vector).\n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["v",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " para representar la velocidad; ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["v",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], 
                StyleBox[" ",
                  FontWeight->"Bold"], "'"}], \((t)\)}], "=", 
            RowBox[{\((x' \((t)\), y' \((t)\), \ z' \((t)\))\), "=", 
              RowBox[{
                RowBox[{\(x'\), \((t)\), 
                  StyleBox["i",
                    FontWeight->"Bold"]}], "+", 
                RowBox[{\(y'\), \((t)\), 
                  StyleBox["j",
                    FontWeight->"Bold"]}], "+", 
                RowBox[{\(z'\), \((t)\), 
                  StyleBox["k",
                    FontWeight->"Bold"]}]}]}]}]}], TraditionalForm]]],
  " (es un vector).\n",
  Cell[BoxData[
      \(TraditionalForm\`v(t)\)]],
  " para representar la rapidez;  ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(v(t)\), "=", 
          RowBox[{
            RowBox[{"||", 
              RowBox[{
                StyleBox["v",
                  FontWeight->"Bold"], "(", "t", ")"}], "||"}], "=", 
            \(\@\(x' \((t)\)\^2 + y' \((t)\)\^2 + z' \((t)\)\^2\)\)}]}], 
        TraditionalForm]]],
  "(es un n\[UAcute]mero).\n",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["a",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " para representar la aceleraci\[OAcute]n; ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["a",
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["v",
                  FontWeight->"Bold"], "'"}], \((t)\)}], "=", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], "'"}], "'"}], \((t)\)}], "=", 
              RowBox[{
              \((\(x'\)' \((t)\), \(y'\)' \((t)\), \(z'\)' \((t)\))\), "=", 
                RowBox[{
                  RowBox[{\(\(x'\)'\), \((t)\), 
                    StyleBox["i",
                      FontWeight->"Bold"]}], "+", 
                  RowBox[{\(\(y'\)'\), \((t)\), 
                    StyleBox["j",
                      FontWeight->"Bold"]}], "+", 
                  RowBox[{\(\(z'\)'\), \((t)\), 
                    StyleBox["k",
                      FontWeight->"Bold"]}]}]}]}]}]}], TraditionalForm]]],
  " (es un vector).\nSeguiremos estas notaciones de aqu\[IAcute] en \
adelante."
}], "Text"],

Cell[TextData[{
  "Como en todo instante ",
  StyleBox["t",
    FontSlant->"Italic"],
  " el triedro intr\[IAcute]nseco ",
  Cell[BoxData[
      FormBox[
        StyleBox[\({T(t), N(t), B(t)}\),
          FontWeight->"Bold"], TraditionalForm]]],
  " forma una base ortonormal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  ", podemos referir a dicha base cualquier vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["u",
            FontWeight->"Bold"], "\[Element]", 
          FormBox[\(\[DoubleStruckCapitalR]\^3\),
            "TraditionalForm"]}], TraditionalForm]]],
  " y sabemos que dicho vector es igual a la suma de sus proyecciones \
ortogonales sobre los elementos de dicha base, esto es:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          StyleBox[" ",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox["u",
              FontWeight->"Bold"], 
            StyleBox["=",
              FontWeight->"Bold"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["\[LeftAngleBracket]",
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox["u",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    StyleBox["|",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["T",
                        FontWeight->"Bold"], 
                      StyleBox["(",
                        FontWeight->"Plain"], 
                      StyleBox["t",
                        FontWeight->"Plain"], 
                      StyleBox[")",
                        FontWeight->"Plain"]}]}], 
                  StyleBox["\[RightAngleBracket]",
                    FontWeight->"Bold"]}], 
                RowBox[{
                  StyleBox["T",
                    FontWeight->"Bold"], 
                  StyleBox["(",
                    FontWeight->"Plain"], 
                  StyleBox["t",
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}]}], 
              StyleBox["+",
                FontWeight->"Bold"], 
              RowBox[{
                RowBox[{
                  StyleBox["\[LeftAngleBracket]",
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox["u",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    StyleBox["|",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["N",
                        FontWeight->"Bold"], 
                      StyleBox["(",
                        FontWeight->"Plain"], 
                      StyleBox["t",
                        FontWeight->"Plain"], 
                      StyleBox[")",
                        FontWeight->"Plain"]}]}], 
                  StyleBox["\[RightAngleBracket]",
                    FontWeight->"Bold"]}], 
                RowBox[{
                  StyleBox["N",
                    FontWeight->"Bold"], 
                  StyleBox["(",
                    FontWeight->"Plain"], 
                  StyleBox["t",
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}]}], 
              StyleBox["+",
                FontWeight->"Bold"], 
              RowBox[{
                RowBox[{
                  StyleBox["\[LeftAngleBracket]",
                    FontWeight->"Bold"], 
                  RowBox[{
                    StyleBox["u",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    StyleBox["|",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["B",
                        FontWeight->"Bold"], 
                      StyleBox["(",
                        FontWeight->"Plain"], 
                      StyleBox["t",
                        FontWeight->"Plain"], 
                      StyleBox[")",
                        FontWeight->"Plain"]}]}], 
                  StyleBox["\[RightAngleBracket]",
                    FontWeight->"Bold"]}], 
                StyleBox["B",
                  FontWeight->"Bold"], \((t)\)}]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Como el vector velocidad tiene la direcci\[OAcute]n del vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["T",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " se sigue que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{
                StyleBox["v",
                  FontWeight->"Bold"], "(", "t", ")"}], "|", 
              StyleBox[" ",
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox["N",
                  FontWeight->"Bold"], "(", "t", ")"}]}], 
            "\[RightAngleBracket]"}], "=", 
          RowBox[{
            RowBox[{"\[LeftAngleBracket]", 
              RowBox[{
                RowBox[{
                  StyleBox["v",
                    FontWeight->"Bold"], "(", "t", ")"}], "|", 
                StyleBox[" ",
                  FontWeight->"Bold"], 
                RowBox[{
                  StyleBox["B",
                    FontWeight->"Bold"], "(", "t", ")"}]}], 
              "\[RightAngleBracket]"}], "=", "0"}]}], TraditionalForm]]],
  ", por lo que"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          StyleBox[" ",
            FontWeight->"Bold"], 
          RowBox[{
            RowBox[{
              StyleBox["v",
                FontWeight->"Bold"], \((t)\)}], 
            StyleBox["=",
              FontWeight->"Bold"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["\[LeftAngleBracket]",
                    FontWeight->"Bold"], 
                  RowBox[{
                    RowBox[{
                      StyleBox["v",
                        FontWeight->"Bold"], "(", "t", ")"}], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    StyleBox["|",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], 
                    RowBox[{
                      StyleBox["T",
                        FontWeight->"Bold"], 
                      StyleBox["(",
                        FontWeight->"Plain"], 
                      StyleBox["t",
                        FontWeight->"Plain"], 
                      StyleBox[")",
                        FontWeight->"Plain"]}]}], 
                  StyleBox["\[RightAngleBracket]",
                    FontWeight->"Bold"]}], 
                RowBox[{
                  StyleBox["T",
                    FontWeight->"Bold"], 
                  StyleBox["(",
                    FontWeight->"Plain"], 
                  StyleBox["t",
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}]}], 
              StyleBox["=",
                FontWeight->"Plain"], 
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["\[LeftAngleBracket]",
                      FontWeight->"Plain"], 
                    RowBox[{
                      RowBox[{
                        StyleBox["v",
                          FontWeight->"Bold"], "(", "t", ")"}], 
                      StyleBox[
                        RowBox[{
                          StyleBox[" ",
                            FontWeight->"Bold"], 
                          StyleBox[" ",
                            FontWeight->"Plain"]}]], 
                      StyleBox["|",
                        FontWeight->"Plain"], 
                      FractionBox[
                        RowBox[{
                          RowBox[{
                            StyleBox["v",
                              FontWeight->"Bold"], \((t)\)}], 
                          StyleBox[" ",
                            FontWeight->"Bold"]}], 
                        RowBox[{
                          RowBox[{"||", 
                            RowBox[{
                              StyleBox["v",
                                FontWeight->"Bold"], " ", \((t)\)}], 
                            StyleBox[" ",
                              FontWeight->"Bold"], "||"}], " "}]]}], 
                    "\[RightAngleBracket]"}], 
                  RowBox[{
                    StyleBox["T",
                      FontWeight->"Bold"], "(", "t", ")"}]}], "=", 
                RowBox[{
                  RowBox[{"||", 
                    RowBox[{
                      StyleBox["v",
                        FontWeight->"Bold"], "(", "t", ")"}], "||", 
                    RowBox[{
                      StyleBox["T",
                        FontWeight->"Bold"], "(", "t", ")"}]}], "=", 
                  RowBox[{\(v(t)\), 
                    StyleBox["T",
                      FontWeight->"Bold"], \((t)\)}]}]}]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Es decir, las componentes del vector velocidad en el triedro \
intr\[IAcute]nseco son ",
  Cell[BoxData[
      \(TraditionalForm\`\((v(t), 0, 0)\)\)]],
  ".\nDerivando la igualdad anterior obtenemos:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["a",
              FontWeight->"Bold"], \((t)\)}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["v",
                  FontWeight->"Bold"], "'"}], \((t)\)}], "=", 
            RowBox[{
              RowBox[{
                RowBox[{\(v'\), \((t)\), 
                  RowBox[{
                    StyleBox["T",
                      FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
                RowBox[{\(v(t)\), 
                  RowBox[{
                    StyleBox["T",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], "'"}], \((t)\)}]}], "=", 
              RowBox[{
                RowBox[{
                  RowBox[{\(v'\), \((t)\), 
                    RowBox[{
                      StyleBox["T",
                        FontWeight->"Bold"], "(", "t", ")"}]}], 
                  "+", \(v(t)\)}], "||", 
                RowBox[{
                  RowBox[{
                    StyleBox["T",
                      FontWeight->"Bold"], " ", "'"}], \((t)\)}], "||", " ", 
                RowBox[{
                  StyleBox["N",
                    FontWeight->"Bold"], \((t)\)}]}]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que es la expresi\[OAcute]n del vector aceleraci\[OAcute]n en el triedro \
intr\[IAcute]nseco. Esta igualdad nos dice que el vector aceleraci\[OAcute]n \
est\[AAcute] siempre situado en el plano engendrado por los vectores",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{
            StyleBox["T",
              FontWeight->"Bold"], "(", "t", ")"}]}], TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["N",
            FontWeight->"Bold"], "(", "t", ")"}], TraditionalForm]]],
  " por lo que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{
                StyleBox["a",
                  FontWeight->"Bold"], "(", "t", ")"}], "|", 
              StyleBox[" ",
                FontWeight->"Bold"], 
              RowBox[{
                StyleBox["B",
                  FontWeight->"Bold"], "(", "t", ")"}]}], 
            "\[RightAngleBracket]"}], "=", "0"}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{
                StyleBox["a",
                  FontWeight->"Bold"], "(", "t", ")"}], "|", " ", 
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold"], "(", "t", ")"}]}], 
            "\[RightAngleBracket]"}], "=", \(v' \((t)\)\)}], 
        TraditionalForm]]],
  " y ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{
                StyleBox["a",
                  FontWeight->"Bold"], "(", "t", ")"}], "|", " ", 
              RowBox[{
                StyleBox["N",
                  FontWeight->"Bold"], "(", "t", ")"}]}], 
            "\[RightAngleBracket]"}], "=", 
          RowBox[{\(v(t)\), "||", 
            RowBox[{
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold"], " ", "'"}], \((t)\)}], "||"}]}], 
        TraditionalForm]]],
  ". El vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(a\_T\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{\(v'\), \((t)\), 
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], "(", "t", ")"}]}]}], TraditionalForm]]],
  ", que es la proyecci\[OAcute]n ortogonal de la aceleraci\[OAcute]n sobre \
el vector tangente unitario, se llama ",
  StyleBox["aceleraci\[OAcute]n tangencial",
    FontWeight->"Bold"],
  ". El vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(a\_N\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{\(v(t)\), "||", 
            RowBox[{
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold"], " ", "'"}], \((t)\)}], "||", " ", 
            RowBox[{
              StyleBox["N",
                FontWeight->"Bold"], "(", "t", ")"}]}]}], TraditionalForm]]],
  ", que es la proyecci\[OAcute]n ortogonal de la aceleraci\[OAcute]n sobre \
el vector normal principal, se llama ",
  StyleBox["aceleraci\[OAcute]n normal",
    FontWeight->"Bold"],
  ". Es decir, las componentes del vector aceleraci\[OAcute]n en el triedro \
intr\[IAcute]nseco son ",
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{\(v' \((t)\)\), ",", 
            RowBox[{\(v(t)\), "||", 
              RowBox[{
                RowBox[{
                  StyleBox["T",
                    FontWeight->"Bold"], " ", "'"}], \((t)\)}], "||"}], ",", 
            "0"}], ")"}], TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["Advertencia.",
    FontWeight->"Bold"],
  " En muchos textos de f\[IAcute]sica se llama aceleraci\[OAcute]n \
tangencial a la ",
  StyleBox["norma",
    FontSlant->"Italic"],
  " del vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(a\_T\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{\(v'\), \((t)\), 
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], "(", "t", ")"}]}]}], TraditionalForm]]],
  " y la representan por ",
  Cell[BoxData[
      \(TraditionalForm\`\(a\_T\)(t) = v\ ' \((t)\)\)]],
  ", es decir, la aceleraci\[OAcute]n tangencial es la derivada de la \
rapidez. Esta aceleraci\[OAcute]n representa la ",
  StyleBox[
  "variaci\[OAcute]n de la velocidad en la direcci\[OAcute]n del movimiento",
    FontSlant->"Italic"],
  " y cuando un veh\[IAcute]culo acelera es la que hace que tu espalda se \
pegue al asiento. As\[IAcute] mismo, es frecuente llamar ",
  StyleBox["aceleraci\[OAcute]n normal",
    FontWeight->"Bold"],
  " y tambi\[EAcute]n ",
  StyleBox["aceleraci\[OAcute]n centr\[IAcute]peta ",
    FontWeight->"Bold"],
  "a la ",
  StyleBox["norma",
    FontSlant->"Italic"],
  " del vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox[\(a\_N\),
              FontWeight->"Bold"], "(", "t", ")"}], "=", 
          RowBox[{\(v(t)\), "||", 
            RowBox[{
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold"], " ", "'"}], \((t)\)}], "||", " ", 
            RowBox[{
              StyleBox["N",
                FontWeight->"Bold"], "(", "t", ")"}]}]}], TraditionalForm]]],
  " y representarla por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox[
                SubscriptBox[
                  StyleBox["a",
                    FontWeight->"Plain"], "N"],
                FontWeight->"Bold"], "(", "t", ")"}], "=", 
            RowBox[{\(v(t)\), "||", 
              RowBox[{
                RowBox[{
                  StyleBox["T",
                    FontWeight->"Bold"], " ", "'"}], \((t)\)}], "||"}]}], 
          " "}], TraditionalForm]]],
  ". Esta aceleraci\[OAcute]n representa la variaci\[OAcute]n de la direcci\
\[OAcute]n del vector tangente unitario, tiene la direcci\[OAcute]n de la \
normal a la curva y es la responsable de que cuando un veh\[IAcute]culo toma \
una curva te sientas empujado contra una puerta."
}], "Text"],

Cell["\<\
Expresiones \[UAcute]tiles para las aceleraciones tangencial y normal se \
deducen de las igualdades\
\>", "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{"\[LeftAngleBracket]", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], "'"}], \((t)\)}], "|", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "'"}], "'"}], \((t)\)}]}], 
            "\[RightAngleBracket]"}], "=", 
          RowBox[{
            RowBox[{"\[LeftAngleBracket]", 
              RowBox[{
                RowBox[{
                  StyleBox["v",
                    FontWeight->"Bold"], "(", "t", ")"}], " ", "|", " ", 
                RowBox[{
                  StyleBox["a",
                    FontWeight->"Bold"], "(", "t", ")"}]}], 
              "\[RightAngleBracket]"}], "=", 
            RowBox[{
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{\(v(t)\), 
                    RowBox[{
                      StyleBox["T",
                        FontWeight->"Bold"], "(", "t", ")"}]}], " ", "|", " ",
                   
                  RowBox[{
                    RowBox[{
                      RowBox[{\(v'\), \((t)\), 
                        RowBox[{
                          StyleBox["T",
                            FontWeight->"Bold"], "(", "t", ")"}]}], 
                      "+", \(v(t)\)}], "||", 
                    RowBox[{
                      RowBox[{
                        StyleBox["T",
                          FontWeight->"Bold"], " ", "'"}], \((t)\)}], "||", 
                    " ", 
                    RowBox[{
                      StyleBox["N",
                        FontWeight->"Bold"], "(", "t", ")"}]}]}], 
                "\[RightAngleBracket]"}], "=", \(\(v(t)\) v' \((t)\)\)}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["r",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontWeight->"Bold",
                FontSlant->"Italic"], "'"}], \((t)\), "\[Times]", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold"], "'"}], "'"}], \((t)\)}], "=", 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["v",
                  FontWeight->"Bold"], "(", "t", ")"}], " ", "\[Times]", " ", 
              
              RowBox[{
                StyleBox["a",
                  FontWeight->"Bold"], "(", "t", ")"}]}], "=", 
            RowBox[{
              RowBox[{\(v(t)\), 
                RowBox[{
                  StyleBox["T",
                    FontWeight->"Bold"], "(", "t", ")"}], " ", "\[Times]", 
                RowBox[{"(", " ", 
                  RowBox[{
                    RowBox[{
                      RowBox[{\(v'\), \((t)\), 
                        RowBox[{
                          StyleBox["T",
                            FontWeight->"Bold"], "(", "t", ")"}]}], 
                      "+", \(v(t)\)}], "||", 
                    RowBox[{
                      RowBox[{
                        StyleBox["T",
                          FontWeight->"Bold"], " ", "'"}], \((t)\)}], "||", 
                    " ", 
                    RowBox[{
                      StyleBox["N",
                        FontWeight->"Bold"], "(", "t", ")"}]}], ")"}]}], "=", 
              
              RowBox[{\(\(v(t)\)\^2\), "||", 
                RowBox[{
                  RowBox[{
                    StyleBox["T",
                      FontWeight->"Bold"], 
                    StyleBox[" ",
                      FontWeight->"Bold"], "'"}], \((t)\)}], "||", 
                RowBox[{
                  StyleBox["B",
                    FontWeight->"Bold"], \((t)\)}]}]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell["de donde", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox[\(\(a\_T\)(t)\),
          FontSlant->"Italic"], "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["v",
                FontSlant->"Italic"], "'"}], \((t)\)}], "=", 
          RowBox[{
            FractionBox[
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    StyleBox["v",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "(", "t", ")"}], "|", 
                  RowBox[{
                    StyleBox["a",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "(", "t", ")"}]}], 
                "\[RightAngleBracket]"}], 
              RowBox[{
                StyleBox["v",
                  FontSlant->"Italic"], "(", "t", ")"}]], "=", 
            FractionBox[
              RowBox[{"\[LeftAngleBracket]", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], "'"}], \((t)\)}], "|", 
                  RowBox[{
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], "''"}], \((t)\)}]}], 
                "\[RightAngleBracket]"}], 
              RowBox[{"||", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "'"}], \((t)\)}], "||", 
                " "}]]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox[
            StyleBox["a",
              FontSlant->"Italic"], 
            StyleBox["N",
              FontSlant->"Italic"]], 
          StyleBox[\((t)\),
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["v",
                FontSlant->"Italic"], "(", "t", ")"}], "||", 
            RowBox[{
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], "'"}], \((t)\)}], "||"}], "=", 
          RowBox[{
            FractionBox[
              RowBox[{"||", 
                RowBox[{
                  RowBox[{
                    StyleBox["v",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "(", "t", ")"}], 
                  "\[Times]", \(a(t)\)}], "||"}], 
              RowBox[{
                StyleBox["v",
                  FontSlant->"Italic"], "(", "t", ")"}]], "=", 
            FractionBox[
              RowBox[{"||", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "'"}], \((t)\), "\[Times]", 
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "''"}], \((t)\)}], "||"}], 
              RowBox[{"||", 
                RowBox[{
                  RowBox[{
                    StyleBox["r",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "'"}], \((t)\)}], "||", 
                " "}]]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La curvatura de una curva suave ",
  StyleBox["r",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(t) es, por definici\[OAcute]n, el n\[UAcute]mero"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Kappa] \((t)\)\), "=", 
        FractionBox[
          RowBox[{"||", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], "'"}], \((t)\), "\[Times]", 
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], "'"}], "'"}], \((t)\)}], "||"}], 
          RowBox[{"||", 
            RowBox[{
              RowBox[{
                StyleBox["r",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], "'"}], \((t)\)}], \( || \^3\)}]]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell["\<\
en consecuencia, obtenemos la siguiente expresi\[OAcute]n para la aceleraci\
\[OAcute]n normal\
\>", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox[
            StyleBox["a",
              FontSlant->"Italic"], 
            StyleBox["N",
              FontSlant->"Italic"]], 
          StyleBox[\((t)\),
            FontSlant->"Italic"]}], "=", 
        RowBox[{"\[Kappa]", \((t)\), 
          StyleBox["v",
            FontSlant->"Italic"], \(\((t)\)\^2\)}]}], TextForm]], "Text",
  TextAlignment->Center],

Cell["Obtenemos as\[IAcute] la expresi\[OAcute]n", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["a",
            FontWeight->"Bold"], "(", "t", ")"}], "=", 
        RowBox[{
          RowBox[{\(v'\), \((t)\), 
            RowBox[{
              StyleBox["T",
                FontWeight->"Bold"], "(", "t", ")"}]}], "+", 
          RowBox[{"\[Kappa]", \((t)\), 
            SuperscriptBox[
              RowBox[{
                StyleBox["v",
                  FontSlant->"Italic"], "(", "t", ")"}], "2"], " ", 
            RowBox[{
              StyleBox["N",
                FontWeight->"Bold"], "(", "t", ")"}]}]}]}], 
      TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell["El radio de curvatura se define como", "Text"],

Cell[BoxData[
    \(TextForm\`\[Rho] \((t)\) = 1\/\(\[Kappa] \((t)\)\)\)], "Text",
  TextAlignment->Center],

Cell["por tanto, tambi\[EAcute]n podemos escribir", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox[
            StyleBox["a",
              FontSlant->"Italic"], 
            StyleBox["N",
              FontSlant->"Italic"]], 
          StyleBox[\((t)\),
            FontSlant->"Italic"]}], "=", 
        FractionBox[
          RowBox[{
            StyleBox["v",
              FontSlant->"Italic"], \(\((t)\)\^2\)}], \(\[Rho] \((t)\)\)]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Observaci\[OAcute]n",
  StyleBox[". En algunas de las f\[OAcute]rmulas anteriores interviene el \
producto vectorial. Te recuerdo que este producto solamente est\[AAcute] \
definido para vectores de ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["\[DoubleStruckCapitalR]",
            FontWeight->"Plain"], "3"], TraditionalForm]]],
  StyleBox[" por lo que dichas f\[OAcute]rmulas solamente tienen sentido para \
curvas en el espacio. Pueden particularizarse dichas f\[OAcute]rmulas para \
curvas en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["\[DoubleStruckCapitalR]",
            FontWeight->"Plain"], "2"], TraditionalForm]]],
  StyleBox[" de la forma que sigue. Dada una curva en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["\[DoubleStruckCapitalR]",
            FontWeight->"Plain"], "2"], TraditionalForm]]],
  ",",
  StyleBox[" ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Gamma](t) = \((x(t), y(t))\)\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[", podemos asociarle una curva en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[DoubleStruckCapitalR]\^3\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[" por la igualdad ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[Lambda](t) = \((x(t), y(t), 0)\)\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[" es decir, se trata de la \"misma curva plana \[Gamma] vista \
dentro del espacio tridimensional\". Podemos ahora particularizar las \
expresiones anteriores para \[Lambda] y as\[IAcute] obtenemos las siguientes \
igualdades:\nLa curvatura de una curva plana suave",
    FontWeight->"Plain"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["t",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[\((x(t), y(t))\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" viene dada por",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Kappa](t)\), "=", 
        RowBox[{
          FractionBox[
            RowBox[{"||", 
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], "'"}], \((t)\), "\[Times]", 
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], "''"}], \((t)\)}], "||"}], 
            RowBox[{"||", 
              RowBox[{
                RowBox[{
                  StyleBox["r",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    FontWeight->"Bold",
                    FontSlant->"Italic"], "'"}], \((t)\)}], \( || \^3\)}]], 
          "=", 
          StyleBox[
            RowBox[{
              FractionBox[
                RowBox[{"||", 
                  RowBox[{
                    StyleBox[\((x' \((t)\), y' \((t)\), 0)\),
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "\[Times]", 
                    RowBox[{"(", 
                      RowBox[{
                        RowBox[{
                          StyleBox[\(x''\),
                            FontWeight->"Bold",
                            FontSlant->"Italic"], \((t)\)}], 
                        StyleBox[",",
                          FontWeight->"Bold",
                          FontSlant->"Italic"], 
                        StyleBox[\(y'' \((t)\)\),
                          FontWeight->"Bold",
                          FontSlant->"Italic"], 
                        StyleBox[",",
                          FontWeight->"Bold",
                          FontSlant->"Italic"], 
                        StyleBox["0",
                          FontWeight->"Bold",
                          FontSlant->"Italic"]}], 
                      StyleBox[")",
                        FontWeight->"Bold",
                        FontSlant->"Italic"]}]}], "||"}], 
                RowBox[{"||", 
                  StyleBox[\((x' \((t)\), y' \((t)\), 0)\),
                    FontWeight->"Bold",
                    FontSlant->"Italic"], \( || \^3\)}]], "=", 
              FractionBox[
                RowBox[{"|", 
                  RowBox[{
                    StyleBox[\(x' \((t)\) y'' \((t)\)\),
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox["-",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], " ", 
                    RowBox[{
                      StyleBox[\(x''\),
                        FontWeight->"Bold",
                        FontSlant->"Italic"], \((t)\), 
                      StyleBox[\(y'\),
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox[\((t)\),
                        FontWeight->"Bold",
                        FontSlant->"Italic"]}]}], "|"}], 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{
                      SuperscriptBox[
                        StyleBox[\((x' \((t)\))\),
                          FontWeight->"Bold",
                          FontSlant->"Italic"], "2"], 
                      StyleBox["+",
                        FontWeight->"Bold"], 
                      SuperscriptBox[
                        RowBox[{"(", 
                          StyleBox[\(y' \((t)\)\),
                            FontWeight->"Bold",
                            FontSlant->"Italic"], 
                          StyleBox[")",
                            FontWeight->"Bold",
                            FontSlant->"Italic"]}], "2"]}], ")"}], \(3/
                    2\)]]}],
            FontWeight->"Bold"]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Si en la \[UAcute]ltima expresi\[OAcute]n suprimimos el valor absoluto se \
obtiene lo que se llama \"curvatura con signo\". Podemos particularizar la \
expresi\[OAcute]n obtenida para el caso de que la curva venga dada como la gr\
\[AAcute]fica de una funci\[OAcute]n ",
  StyleBox["f",
    FontSlant->"Italic"],
  ", es decir, por medio de una funci\[OAcute]n del tipo ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](x) = \((x, f(x))\)\)]],
  ". En este caso es f\[AAcute]cil obtener que la curvatura (con signo) viene \
dada por"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{\(\[Kappa](x)\), "=", 
        FractionBox[
          RowBox[{
            RowBox[{
              StyleBox["f",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontWeight->"Bold",
                FontSlant->"Italic"], "''"}], \((x)\)}], 
          SuperscriptBox[
            RowBox[{"(", 
              RowBox[{"1", 
                StyleBox["+",
                  FontWeight->"Bold"], 
                SuperscriptBox[
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        StyleBox["f",
                          FontWeight->"Plain",
                          FontSlant->"Italic"], 
                        StyleBox["'",
                          FontSlant->"Italic"]}], 
                      RowBox[{
                        StyleBox["(",
                          FontWeight->"Bold",
                          FontSlant->"Italic"], 
                        StyleBox["x",
                          FontSlant->"Italic"], 
                        StyleBox[")",
                          FontWeight->"Bold",
                          FontSlant->"Italic"]}]}], 
                    StyleBox[")",
                      FontWeight->"Bold",
                      FontSlant->"Italic"]}], "2"]}], ")"}], \(3/2\)]]}], 
      TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En este caso la curvatura es positiva donde la curva es convexa (",
  Cell[BoxData[
      \(TraditionalForm\`\(f'\)' \((x)\) > 0\)]],
  ") y es negativa donde la curva es c\[OAcute]ncava (",
  Cell[BoxData[
      \(TraditionalForm\`\(f'\)' \((x)\) < 0\)]],
  ")."
}], "Text"],

Cell[TextData[{
  "La (norma de la) componente normal de la aceleraci\[OAcute]n ",
  StyleBox["de una curva plana suave",
    FontWeight->"Plain"],
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["t",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], 
          StyleBox["=",
            FontWeight->"Plain"], 
          StyleBox[\((x(t), y(t))\),
            FontWeight->"Plain"]}], TraditionalForm]]],
  StyleBox[" viene dada por",
    FontWeight->"Plain"]
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          SubscriptBox[
            StyleBox["a",
              FontSlant->"Italic"], 
            StyleBox["N",
              FontSlant->"Italic"]], 
          StyleBox[\((t)\),
            FontSlant->"Italic"]}], "=", 
        RowBox[{
          RowBox[{
            RowBox[{
              StyleBox["v",
                FontSlant->"Italic"], "(", "t", ")"}], "||", 
            RowBox[{
              RowBox[{
                StyleBox["T",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], "'"}], \((t)\)}], "||"}], "=", 
          RowBox[{
            FractionBox[
              RowBox[{"||", 
                RowBox[{
                  RowBox[{
                    StyleBox["v",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], "(", "t", ")"}], 
                  "\[Times]", \(a(t)\)}], "||"}], 
              RowBox[{
                StyleBox["v",
                  FontSlant->"Italic"], "(", "t", ")"}]], "=", 
            RowBox[{
              FractionBox[
                RowBox[{"||", 
                  RowBox[{
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], "'"}], \((t)\), "\[Times]", 
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], "''"}], \((t)\)}], "||"}], 
                RowBox[{"||", 
                  RowBox[{
                    RowBox[{
                      StyleBox["r",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], "'"}], \((t)\)}], "||", " "}]], 
              "=", 
              StyleBox[
                FractionBox[
                  RowBox[{"|", 
                    RowBox[{
                      StyleBox[\(x' \((t)\) y'' \((t)\)\),
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], 
                      StyleBox["-",
                        FontWeight->"Bold",
                        FontSlant->"Italic"], " ", 
                      RowBox[{
                        RowBox[{
                          StyleBox["x",
                            FontWeight->"Bold",
                            FontSlant->"Italic"], 
                          StyleBox["''",
                            FontWeight->"Bold",
                            FontSlant->"Italic"]}], \((t)\), 
                        StyleBox[\(y'\),
                          FontWeight->"Bold",
                          FontSlant->"Italic"], 
                        StyleBox[\((t)\),
                          FontWeight->"Bold",
                          FontSlant->"Italic"]}]}], "|"}], 
                  SuperscriptBox[
                    RowBox[{"(", 
                      RowBox[{
                        SuperscriptBox[
                          StyleBox[\((x' \((t)\))\),
                            FontWeight->"Bold",
                            FontSlant->"Italic"], "2"], 
                        StyleBox["+",
                          FontWeight->"Bold"], 
                        SuperscriptBox[
                          RowBox[{"(", 
                            StyleBox[\(y' \((t)\)\),
                              FontWeight->"Bold",
                              FontSlant->"Italic"], 
                            StyleBox[")",
                              FontWeight->"Bold",
                              FontSlant->"Italic"]}], "2"]}], ")"}], \(1/
                      2\)]],
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Finalmente, te recuerdo la segunda ley del movimiento de Newton, ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["F",
              FontWeight->"Bold"], 
            StyleBox["(",
              FontWeight->"Plain"], 
            StyleBox["t",
              FontWeight->"Plain"], 
            StyleBox[")",
              FontWeight->"Plain"]}], "=", " ", 
          RowBox[{"m", " ", 
            RowBox[{
              StyleBox["a",
                FontWeight->"Bold"], 
              StyleBox["(",
                FontWeight->"Plain"], 
              StyleBox["t",
                FontWeight->"Plain"], 
              StyleBox[")",
                FontWeight->"Plain"]}]}]}], TraditionalForm]]],
  ", donde ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(",
  StyleBox["t",
    FontSlant->"Italic"],
  ") es la resultante de todas las fuerzas que act\[UAcute]an sobre un objeto \
de masa ",
  StyleBox["m",
    FontSlant->"Italic"],
  " y ",
  StyleBox["a",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(",
  StyleBox["t",
    FontSlant->"Italic"],
  ") es la aceleraci\[OAcute]n que experimenta dicho objeto en el instante ",
  StyleBox["t",
    FontSlant->"Italic"],
  ". Conociendo la aceleraci\[OAcute]n es f\[AAcute]cil calcular, por \
integraci\[OAcute]n componente a componente, la velocidad y la \
funci\[OAcute]n de trayectoria."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 12", "Exercise"],

Cell[TextData[{
  "La funci\[OAcute]n de trayectoria de un m\[OAcute]vil viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((3\ cos\ t, \ 3\ sen\ t, t)\)\)]],
  ". \na) Calcula su velocidad y aceleraci\[OAcute]n. \nb) Calcula las \
componentes tangencial y normal de la aceleraci\[OAcute]n.\nc) Calcula el \
triendro intr\[IAcute]nseco de la curva."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 13", "Exercise"],

Cell[TextData[{
  "La funci\[OAcute]n de trayectoria de un m\[OAcute]vil viene dada por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((\ t, \ t\^2)\)\)]],
  ". \na) Calcula su velocidad y aceleraci\[OAcute]n. \nb) Calcula las \
componentes tangencial y normal de la aceleraci\[OAcute]n.\nc) Calcula el \
vector tangente unitario y el vector normal unitario."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 14 (movimiento circular)", "Exercise"],

Cell[TextData[{
  "La funci\[OAcute]n de trayectoria de un m\[OAcute]vil viene dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold",
              FontSlant->"Italic"], "(", "t", ")"}], 
          "=", \((\ R\ cos\ \(\[Theta](t)\), \ R\ sen\ \(\[Theta](t)\))\)}], 
        TraditionalForm]]],
  " donde \[Theta](t) es la medida en radianes del \[AAcute]ngulo que forma \
el vector de posici\[OAcute]n ",
  StyleBox["r",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "(t) con la parte positiva del eje de abscisas. La ",
  StyleBox["velocidad angular",
    FontWeight->"Bold"],
  " del m\[OAcute]vil se define como ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega](t) = \[Theta]\ ' \((t)\)\)]],
  " (la rapidez de variaci\[OAcute]n del \[AAcute]ngulo \[Theta](t) respecto \
del tiempo). La ",
  StyleBox["aceleraci\[OAcute]n angular ",
    FontWeight->"Bold"],
  "se define como \[Omega]'(t). Cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\[Omega]' \((t)\) = 0\)]],
  " se dice que se trata de un ",
  StyleBox["movimiento circular uniforme",
    FontWeight->"Bold"],
  ".\na) Calcula su velocidad y aceleraci\[OAcute]n. \nb) Calcula la \
aceleraci\[OAcute]n tangencial y la aceleraci\[OAcute]n normal.\nc) Calcula \
el vector tangente unitario y el vector normal unitario.\nd) Supuesto que el \
m\[OAcute]vil tiene masa ",
  StyleBox["m",
    FontSlant->"Italic"],
  ", calcula la fuerza necesaria para producir el movimiento.\ne) \
Particulariza los resultados obtenidos para el caso de un movimiento circular \
uniforme."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 15", "Exercise"],

Cell[TextData[{
  "a) Calcula la curvatura de la elipse ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma] : \([0, 2  \[Pi]]\) \[Rule] \[DoubleStruckCapitalR]\^2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((a\ cos\ t, \ b\ sen\ t)\)\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 < b < a\)]],
  ". \[DownQuestion]En qu\[EAcute] puntos la curvatura alcanza sus valores m\
\[AAcute]ximo y m\[IAcute]nimo?\nb) Calcula la curvatura de la \
par\[AAcute]bola de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y = x\^2\)]],
  ". \[DownQuestion]En qu\[EAcute] punto de ella la curvatura alcanza su m\
\[AAcute]ximo valor? \[DownQuestion]Alcanza la curvatura alg\[UAcute]n valor \
m\[IAcute]nimo?\nc) Calcula la curvatura de la c\[UAcute]bica alabeada ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((t, t\^2, t\^3)\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 16", "Exercise"],

Cell[TextData[{
  "Un proyectil se dispara desde el origen con \[AAcute]ngulo de elevaci\
\[OAcute]n \[Alpha] y rapidez inicial ",
  Cell[BoxData[
      \(TraditionalForm\`v\_0\)]],
  ". Suponiendo que la \[UAcute]nica fuerza que act\[UAcute]a sobre el \
proyectil es la de atracci\[OAcute]n gravitatoria, calcular la \
funci\[OAcute]n de trayectoria. \[DownQuestion]Qu\[EAcute] valor de \[Alpha] \
hace m\[AAcute]ximo el alcance del proyectil? \[DownQuestion]Qu\[EAcute] \
valor de \[Alpha] hace que la altura alcanzada sea m\[AAcute]xima y cu\
\[AAcute]l es el valor de \[EAcute]sta? "
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 17", "Exercise"],

Cell[TextData[{
  "Consideremos un p\[EAcute]ndulo ideal. Se trata de un punto material de \
masa m sujeto por una varilla perfectamente r\[IAcute]gida de longitud L y \
masa despreciable que puede girar sin rozamiento alrededor de un punto fijo \
O. Suponemos que el movimiento ocurre en el plano ",
  Cell[BoxData[
      \(TraditionalForm\`X\ \(\(Y\)\(.\)\(\ \)\)\)]],
  "Elegimos el punto O como origen de coordenadas y notamos ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["i",
              FontWeight->"Bold"], "=", \((1, 0)\)}], ",", 
          RowBox[{
            StyleBox["j",
              FontWeight->"Bold"], 
            StyleBox["=",
              FontWeight->"Plain"], 
            StyleBox[\((0, 1)\),
              FontWeight->"Plain"]}]}], TraditionalForm]]],
  " los vectores de la base can\[OAcute]nica. Notamos por ",
  Cell[BoxData[
      \(TraditionalForm\`y(t)\)]],
  " la medida en radianes del \[AAcute]ngulo que forma la varilla con el \
semieje negativo de ordenadas (la vertical por O). Los \[AAcute]ngulos se \
miden hacia la derecha con valores positivos y hacia la izquierda con valores \
negativos. Inicialmente se supone que el p\[EAcute]ndulo est\[AAcute] en el \
punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, \(-L\))\)\)]],
  ". "
}], "ExerciseText"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .71875 
%%ImageSize: 144 103.5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0625 0.5625 0.0625 [
[ 0 0 0 0 ]
[ 1 .71875 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .71875 L
0 .71875 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 g
.003 w
[ ] 0 setdash
.5 .5625 m
.5 .0625 L
s
0 .1 1 r
.03 w
.1875 .0625 m
.8125 .0625 L
s
0 g
.0065 w
.5 .5625 m
.77063 .40625 L
s
1 0 0 r
.77063 .40625 m
.77063 .40625 .02083 0 365.73 arc
F
0 g
.015 w
.77063 .40625 Mdot
.02 w
.5 .5625 Mdot
.5 Mabswid
.5 .40625 m
.5002 .40625 L
.50039 .40625 L
.5006 .40625 L
.5008 .40625 L
.50116 .40625 L
.50154 .40626 L
.50197 .40626 L
.50242 .40627 L
.50323 .40628 L
.50407 .4063 L
.50485 .40633 L
.50664 .40639 L
.50845 .40648 L
.51012 .40658 L
.51386 .40687 L
.5171 .40719 L
.52064 .40762 L
.52754 .4087 L
.53413 .41002 L
.54106 .41174 L
.54766 .4137 L
.55392 .41585 L
.56048 .41843 L
.56667 .42119 L
.57251 .4241 L
.57859 .42745 L
.5843 .43094 L
.59019 .43491 L
.59569 .43898 L
.60081 .44312 L
.60606 .44776 L
.61092 .45245 L
.61539 .45714 L
.61993 .46235 L
.62408 .46754 L
.62825 .47324 L
.63201 .47892 L
.63532 .48437 L
s
gsave
.59375 .40012 -71 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
64.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
69.000 15.000 moveto
(H) show
73.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
76.000 15.000 moveto
(L) show
79.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.6395 .55413 -66 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(L) show
69.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
newpath
.5 .5625 .3125 0 365.73 arc
s
.77063 .40625 m
.66238 .21875 L
s
% Start of user PostScript
4.33013 -2.5 2.59808 -5.5 MAarrowhead1
% End of user PostScript
.77063 .40625 m
.87889 .34375 L
s
% Start of user PostScript
4.33013 -2.5 6.06218 -3.5 MAarrowhead1
% End of user PostScript
.77063 .40625 m
.66238 .46875 L
s
% Start of user PostScript
4.33013 -2.5 2.59808 -1.5 MAarrowhead1
% End of user PostScript
.77063 .40625 m
.77063 .15625 L
s
% Start of user PostScript
4.33013 -2.5 4.33013 -6.5 MAarrowhead1
% End of user PostScript
gsave
.84375 .2625 -70 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
64.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(mg) show
77.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.5 .61875 -66.5 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(O) show
70.000 15.000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144, 103.5},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003H0000Vb000`400?l00000o`00003of03oool0
0=P0oooo003H0?ooo`00f03oool00=P0oooo003H0?ooo`00f03oool00=P0oooo003H0?ooo`00f03o
ool00=P0oooo003H0?ooo`009@3ooon<000IobL0oooo000U0?oooh`001Wo9`3oool002D0ooooS000
6OlW0?ooo`009@3ooon<000IobL0oooo000U0?oooh`001Wo9`3oool002D0ooooS0006OlW0?ooo`00
J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool0
0`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000
oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?oo
o`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?oo
o`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3o
ool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`00
0000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`1Z0?ooo`00J`3oool00`000000oooo
0?ooo`1Z0?ooo`00J`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo0300oooo001[
0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0<03oool006/0oooo00<000000?oo
o`3oool0=P3oool300000340oooo001[0?ooo`030000003oool0oooo03H0oooo0`00000a0?ooo`00
J`3oool00`000000oooo0?ooo`0f0?ooo`<00000<@3oool006/0oooo00<000000?ooo`3oool0=P3o
ool300000340oooo001[0?ooo`030000003oool0oooo03D0oooo1@00000`0?ooo`00J`3oool00`00
0000oooo0?ooo`0e0?ooo`D00000<03oool006/0oooo00<000000?ooo`3oool0=@3oool500000300
oooo001[0?ooo`030000003oool0oooo03D0oooo1@00000`0?ooo`00J`3oool00`000000oooo0?oo
o`0d0?ooo`L00000;`3oool006/0oooo00<000000?ooo`3oool0=03oool7000002l0oooo001[0?oo
o`030000003oool0oooo03L0oooo00<000000?ooo`3oool0<03oool006/0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0300oooo001[0?ooo`030000
003oool0oooo0200oooo0P00000E0?ooo`030000003oool0oooo0300oooo001[0?ooo`030000003o
ool0oooo0240oooo0P00000D0?ooo`030000003oool0oooo00l0oooo00<0oooD09/0000000000P00
00000`1b^^X0oooo0?ooo`0I0?ooo`00J`3oool00`000000oooo0?ooo`0Q0?ooo`<000004`3oool0
0`000000oooo0?ooo`0?0?ooo`030=BK0000Vm@0oooo0080oooo00<0j[Yb09_Do`3oool06@3oool0
06/0oooo00<000000?ooo`3oool08@3oool400000180oooo00<000000?ooo`3oool03`3oool00`3o
om@0^[[Z0?ooo`020?ooo`030?oZ^P1bVm@0oooo01T0oooo001[0?ooo`030000003oool0oooo0240
oooo1@00000A0?ooo`030000003oool0oooo00<0oooo00h0oooD09/000000000001b0;[Ze02K0000
00000000LP2jj]@0V`000000000009/0e?oZ0;Yb00@0000000<0VmCo0?ooo`3oool0603oool006/0
oooo00<000000?ooo`3oool08P3oool500000100oooo00<000000?ooo`3oool0103oool03P3oj[X0
LP1b0;[Zo`3oool0onZj0780LP2jj_l0oooo0?oZ^P1b0780^^[o0?ooe02KL[X0j_oo7P3oool006<0
oooo4@00000L0?ooo`H000003`3oool00`000000oooo0?ooo`040?ooo`0A0?oZ^P1b0780^^[o0?oo
o`3oj[X0LP1b0;[Zo`3oool0onZj0780LP2jj_l0oooo0?oZ^P1b000000000000V`3Dool06`3oool0
05h0oooo1@0000080?ooo`030000003oool0oooo00H0oooo1@00000G0?ooo`L000003P3oool00`00
0000oooo0?ooo`040?ooo`0A0?oZ^P1b0780^^[o0?ooo`3oj[X0LP1b0;[Zo`3oool0onZj0780LP2j
j_l0oooZ0;Yb001b^^X0oooo0>ZjLP00Vm@06`3oool005T0oooo1@00000=0?ooo`030000003oool0
oooo00/0oooo1@00000B0?ooo`H000003`3oool00`000000oooo0?ooo`040?ooo`0B0?oZ^P1b0780
^^[o0?ooo`3oj[X0LP1b0;[Zo`3oool0onZj0780LP2jj_l0onZj0780LP2jj_l0oooo0?oDV`00L[X0
j_oo6P3oool005H0oooo0`00000B0?ooo`030000003oool0oooo0100oooo0`00000@0?ooo`@00000
403oool00`000000oooo0?ooo`030?ooo`0B0?oZ^P1b000000000000V`3Dool0omBK0000000009/0
e?oo0?oDV`0009/0e?oo0?ooe02K0000VmCo0?ooo`3DV`0009_D6`3oool005@0oooo0P00000E0?oo
o`030000003oool0oooo01<0oooo0P00000>0?ooo`040000003oool0oooo00000100oooo00<00000
0?ooo`3oool0103oool02P3oj[X0LP1b0;[Ze02K00000000002Ke03oom@0V`000000001b^^X20?oo
o`030?oZ^P1b000000000080000000<007:j0>[oo`3oool0603oool00540oooo0`00000G0?ooo`03
0000003oool0oooo01D0oooo0`00000?0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0<03oool004h0oooo0`00000J0?ooo`030000003oool0oooo01P0oooo0`00000<0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool0<03oool004`0oooo0P00000M0?ooo`030000003o
ool0oooo01/0oooo0P00000;0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0<03o
ool004X0oooo0P00000O0?ooo`030000003oool0oooo01d0oooo0P00000:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0<03oool004T0oooo00<000000?ooo`3oool07`3oool00`00
0000oooo0?ooo`0O0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0`0?ooo`00B03oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0300
oooo00170?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool08@3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0<03oool004D0oooo0P00
000T0?ooo`030000003oool0oooo0280oooo0P0000070?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0<03oool004@0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0`
0?ooo`00@P3oool2000002L0oooo00<000000?ooo`3oool09@3oool2000000D0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`0`0?ooo`00@@3oool00`000000oooo0?ooo`0W0?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0300oooo00100?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
<03oool003l0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0Y0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0`0?ooo`00?@3oool2
000002`0oooo00<000000?ooo`3oool0:P3oool200000080oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`0`0?ooo`00?03oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo
02`0oooo00@000000?ooo`3oool000001`3oool00`000000oooo0?ooo`0`0?ooo`00>`3oool00`00
0000oooo0?ooo`0]0?ooo`030000003oool0oooo02d0oooo00@000000?ooo`3oool000001P3oool0
0`000000oooo0?ooo`0C0?ooo`8000006`3oool003X0oooo00<000000?ooo`3oool0;P3oool00`00
0000oooo0?ooo`0^0?ooo`030000003oool0000000H0oooo00<000000?ooo`3oool0403oool40000
01`0oooo000i0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0;`3oool00`000000
oooo000000050?ooo`030000003oool0oooo00`0oooo1`00000M0?ooo`00>@3oool00`000000oooo
0?ooo`0_0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`0000001@3oool00`000000oooo
0?ooo`0:0?ooo`P000007P3oool003P0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?oo
o`070?ooo`030>ZjLP00000009_D00L0oooo00<0e9/009_Do`3oool01@3oool00`3oe9/009_D0?oo
o`0D0?ooo`030000003oool0000000@0oooo00<000000?ooo`3oool02P3oool7000001l0oooo000g
0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool02@3oool00`3oe9/0VmCo0?ooo`04
0?ooo`030>ZjLP2Ke?l0oooo00L0oooo00<0omBK07:jjP3oool0503oool2000000@0oooo00<00000
0?ooo`3oool02`3oool500000200oooo000f0?ooo`030000003oool0oooo0380oooo00<000000?oo
o`3oool02@3oool00`3oonX0^Y^j0>[oo`030?ooo`030?oZ^P1bVm@0oooo00T0oooo00<0e9]b0;[Z
o`3oool0503oool2000000<0oooo00<000000?ooo`3oool02@3oool600000240oooo000e0?ooo`03
0000003oool0oooo03<0oooo00<000000?ooo`3oool02P3oool00`3Z^Y/0^^[o0?ooo`020?ooo`03
0=BK002Ke?l0oooo00<0oooo00@0e9/000000000L[X0j_oo0P3oool00`3oe9/009_D0?ooo`0E0?oo
o`8000000P3oool00`000000oooo0?ooo`070?ooo`8000000`3oool200000280oooo000e0?ooo`03
0000003oool0oooo03<0oooo00<000000?ooo`3oool02@3oool00`3oom@0V`0007:jjP020?ooo`03
0?ooe02K0780^^[o00<0oooo00<0oooD09/0002Ke?l0103oool00`3oj[X0LP2K0=Coo`0E0?ooo`80
00000P3oool00`000000oooo0?ooo`050?ooo`8000001@3oool00`000000oooo0?ooo`0Q0?ooo`00
=03oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo00T0oooo00P0j[Yb001bV`2KLY/0
e?oo0?ooo`3oj[X0LP2K0=Coo`<0oooo00<0oooD09/0002Ke?l0103oool00`3oom@0V`1b0;[Zo`0F
0?ooo`80000000<0oooo0000003oool01@3oool00`000000oooo0?ooo`0Y0?ooo`00<`3oool00`00
0000oooo0?ooo`0e0?ooo`030000003oool0oooo00P0oooo00T0oooD09/0002Ke?l0omBK09_Do`3o
ool0onZj0780V`3Dool00`3oool00`3oom@0V`0009_Do`040?ooo`030?ooe02K0780^^[o01H0oooo
00@0o`000000003o000000000P3o00020?ooo`800000;03oool003<0oooo00<000000?ooo`3oool0
=@3oool00`000000oooo0?ooo`080?ooo`090>ZjLP00Vm@0oooo0?oojP2jVkX0j_oo0?oZ^P1b09/0
e?oo00<0oooo00<0oooD09/0002Ke?l0103oool00`3oom@0V`1b0;[Zo`0E0?ooo`80o`000`000002
0?l000800000;P3oool00380oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`070?oo
o`030?ooe02K0000VmCo0080oooo00D0j[ZK0;[Zo`3oj[X0LP2K0=Coo`030?ooo`030?ooe02K0000
VmCo00@0oooo00<0oooD09/0LP2jj_l05@3oool30?l000@0000000<0o`000?ooo`3oool0;@3oool0
0340oooo00<000000?ooo`3oool0=`3oool3000000H0oooo00/0oooZ0;Yb00000000002K0=Coo`3o
om@0V`000000V`3Dom@0V`1b0;[Zo`020?ooo`060?oZ^P1b0000000000000000L[X0j_oo0P3oool0
0`3oj[X0LP2K0=Coo`0E0?ooo`<0o`000`0000030?l002h0oooo000a0?ooo`030000003oool0oooo
03L0oooo00<000000?ooo`0000001@00000:0?ooo`030=BK002Ke?l0oooo0080oooo00<0oooZ0;Yb
002Ke?l0103oool00`3oe9/009_D0?ooo`0E0?ooo`80o`000`0000040?l002h0oooo000`0?ooo`03
0000003oool0oooo03P0oooo00<000000?ooo`3oool01@3oool5000000D0oooo00<0onZj07:Ke03o
ool00`3oool00`3oe9/0VmCo0?ooo`030?ooo`030=BKLP2jj_l0oooo01D0oooo0P0000030?l00003
0000003o0000o`0002l0oooo000`0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`030?ooo`030>ZjLP00Vm@0oooo00L0oooo00<0e9/007:jjP3oool0
5@3oool00`000000oooo0?l000030?l000030000003o0000o`0002l0oooo000_0?ooo`030000003o
ool0oooo03T0oooo00<000000?ooo`3oool02`3oool3000000<0oooo00<0omBj0;[Zo`3oool01@3o
ool00`3oj[X0^]Co0?ooo`0D0?ooo`8000000`3oool40?l000030000003oool0oooo02h0oooo000_
0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0M
0?ooo`8000001@3oool40?l000030000003oool0oooo02h0oooo000^0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0F0?ooo`040000003oool0oooo
0?ooo`800000303oool00`000000oooo0?ooo`0]0?ooo`00;@3oool00`000000oooo0?ooo`0k0?oo
o`030000003oool0oooo0100oooo0`00000D0?ooo`8000000P3oool2000000d0oooo00<000000?oo
o`3oool0;@3oool002d0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo0100oooo1@00000@0?ooo`030000003oool0oooo02`0oooo000]0?ooo`030000
003oool0oooo03/0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0>0?ooo`D00000
4@3oool00`000000oooo0?ooo`0/0?ooo`00;03oool00`000000oooo0?ooo`0l0?ooo`030000003o
ool0oooo01D0oooo00<000000?ooo`3oool0303oool700000100oooo00<000000?ooo`3oool0;03o
ool002`0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo00X0oooo2000000A0?ooo`030000003oool0oooo02/0oooo000[0?ooo`030000003oool0oooo
03d0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`080?ooo`L000004`3oool00`00
0000oooo0?ooo`0[0?ooo`00:`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool01P3oool6000001L0oooo00<000000?ooo`3oool0:P3oool002/0oooo
00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00@0oooo
0`00000K0?ooo`030000003oool0oooo02X0oooo000Z0?ooo`030000003oool0oooo03h0oooo00<0
00000?ooo`3oool06@3oool010000000oooo0?ooo`3oool2000001h0oooo00<000000?ooo`3oool0
:P3oool002X0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0I0?ooo`040000003o
ool0000000000240oooo00<000000?ooo`3oool0:@3oool002X0oooo00<000000?ooo`3oool0?P3o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0:@3o
ool002X0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`0H0?ooo`800000903oool0
0`000000oooo0?ooo`0Y0?ooo`00:P3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo
01H0oooo0P00000V0?ooo`030000003oool0oooo02T0oooo000Y0?ooo`030000003oool0oooo03l0
oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02T0
oooo000Y0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool04`3oool2000002X0oooo
00<000000?ooo`3oool0:03oool002T0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?oo
o`0A0?ooo`800000;03oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?ooo`0o
0?ooo`030000003oool0oooo00l0oooo0P00000^0?ooo`030000003oool0oooo02P0oooo000Y0?oo
o`030000003oool0oooo03l0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0^0?oo
o`030000003oool0oooo02P0oooo000X0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3o
ool0303oool200000340oooo00<000000?ooo`3oool0:03oool002P0oooo00<000000?ooo`3oool0
@03oool00`000000oooo0?ooo`0:0?ooo`800000=03oool00`000000oooo0?ooo`0W0?ooo`00:03o
ool00`000000oooo0?ooo`100?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3o
ool00`3oonX0^W800000000500000003001b^P3Zool0oooo0200oooo00<000000?ooo`3oool09`3o
ool002P0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`070?ooo`8000003P3oool0
0`3Z^W8007:j0>[oo`020?ooo`030?ooe02K09/0e?oo0240oooo00<000000?ooo`3oool09`3oool0
02P0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`050?ooo`800000403oool00`3o
e9/007:j0>[oo`030?ooo`030?oDV`2Ke?l0oooo0200oooo00<000000?ooo`3oool09`3oool002P0
oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`030?ooo`8000004P3oool00`3oe9/0
07:j0>[oo`0V0?ooo`030000003oool0oooo02L0oooo000X0?ooo`030000003oool0oooo0400oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0B0?ooo`030?oDV`00L[X0j_oo02H0oooo
00<000000?ooo`3oool09`3oool002P0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?oo
o`02000001D0oooo00<0omBK001b^P3Zool09P3oool00`000000oooo0?ooo`0W0?ooo`00:03oool0
0`000000oooo0?ooo`0o0?ooo`@000005`3oool00`3oe9/007:j0>[oo`0V0?ooo`030000003oool0
oooo02L0oooo000X0?ooo`030000003oool0oooo03h0oooo1000000H0?ooo`030?oDV`00L[X0j_oo
02H0oooo00<000000?ooo`3oool09`3oool002P0oooo00<000000?ooo`3oool0?P3oool4000001P0
oooo00<0j[Yb001b^P3Zool09P3oool00`000000oooo0?ooo`0W0?ooo`00:03oool00`000000oooo
0?ooo`0o0?ooo`8000005`3oool01P3oonX0^W80000000000000001b0;[ZobD0oooo00<000000?oo
o`3oool09`3oool002P0oooo00<000000?ooo`3oool0P`3oool00`000000oooo0?ooo`0W0?ooo`00
:03oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo02L0oooo000X0?ooo`030000003o
ool0oooo08<0oooo00<000000?ooo`3oool09`3oool002P0oooo00<000000?ooo`3oool0P`3oool0
0`000000oooo0?ooo`0W0?ooo`00:03oool00`000000oooo0?ooo`0m0?ooo`030?oojP2jLP000000
0080000000<009_D0?ooo`3oool0?P3oool00`000000oooo0?ooo`0W0?ooo`00:03oool00`000000
oooo0?ooo`0l0?ooo`030?oZ^P1b000009_D00<0oooo00<0e9/00000V`3Dool0?P3oool00`000000
oooo0?ooo`0W0?ooo`00:03oool00`000000oooo0?ooo`0k0?ooo`040?oojP2jLP0007:j0>[oo`<0
oooo00@0oooZ0;Yb0000L[X0j_oo?03oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000
oooo0?ooo`0j0?ooo`030?oZ^P1b0000L[[Z00D0oooo00<0j[Yb0000LP2jj_l0?03oool00`000000
oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?ooo`0j0?ooo`030?oDV`000000VmCo00D0oooo
00<0omBK0000002Ke?l0?03oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?oo
o`0j0?ooo`030?oDV`000000VmCo00D0oooo00<0omBK0000002Ke?l0?03oool00`000000oooo0?oo
o`0X0?ooo`00:@3oool00`000000oooo0?ooo`0j0?ooo`030?oZ^P1b0000L[[Z00D0oooo00<0j[Yb
0000LP2jj_l0?03oool00`000000oooo0?ooo`0X0?ooo`00:@3oool00`000000oooo0?ooo`0j0?oo
o`040?oojP2jLP0007:j0>[oo`<0oooo00@0oooZ0;Yb0000L[X0j_oo>`3oool00`000000oooo0?oo
o`0Y0?ooo`00:P3oool00`000000oooo0?ooo`0j0?ooo`030?ooe02K000009_D00<0oooo00<0e9/0
0000V`3Dool0?03oool00`000000oooo0?ooo`0Y0?ooo`00:P3oool00`000000oooo0?ooo`0l0?oo
o`050=BK00000000000000000000Vm@0?P3oool00`000000oooo0?ooo`0Y0?ooo`00:P3oool00`00
0000oooo0?ooo`1o0?ooo`030000003oool0oooo02T0oooo000Z0?ooo`030000003oool0oooo07l0
oooo00<000000?ooo`3oool0:@3oool002X0oooo00<000000?ooo`3oool0OP3oool00`000000oooo
0?ooo`0Z0?ooo`00:`3oool00`000000oooo0?ooo`1m0?ooo`030000003oool0oooo02X0oooo000[
0?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool0:P3oool002/0oooo00<000000?oo
o`3oool0O03oool00`000000oooo0?ooo`0[0?ooo`00;03oool00`000000oooo0?ooo`1k0?ooo`03
0000003oool0oooo02/0oooo000]0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3oool0
;03oool002d0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`0/0?ooo`00;@3oool0
0`000000oooo0?ooo`1i0?ooo`030000003oool0oooo02`0oooo000]0?ooo`030000003oool0oooo
07P0oooo00<000000?ooo`3oool0;@3oool002h0oooo00<000000?ooo`3oool0M`3oool00`000000
oooo0?ooo`0]0?ooo`00;`3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo02h0oooo
000_0?ooo`030000003oool0oooo07D0oooo00<000000?ooo`3oool0;P3oool00300oooo00<00000
0?ooo`3oool0L`3oool00`000000oooo0?ooo`0_0?ooo`00<03oool00`000000oooo0?ooo`1c0?oo
o`030000003oool0oooo02l0oooo000a0?ooo`030000003oool0oooo0740oooo00<000000?ooo`3o
ool0<03oool00001\
\>"],
  ImageRangeCache->{{{0, 215}, {154.25, 0}} -> {-8.01467, -9.00006, 0.111833, \
0.111833}}],

Cell[TextData[{
  "a) Escribe la ecuaci\[OAcute]n de la trayectoria que sigue el \
p\[EAcute]ndulo en funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`y(t)\)]],
  ".\nb) Aplicando la segunda ley del movimiento de Newton deduce que ",
  Cell[BoxData[
      \(TraditionalForm\`y(t)\)]],
  " verifica la ecuaci\[OAcute]n diferencial ",
  Cell[BoxData[
      \(TraditionalForm\`y'' \((t)\) + \(g\/L\) \(sen(y(t))\) = 0\)]],
  "."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{3, 3},
PageHeaders->{{Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Estructura eucl\[IAcute]dea de ", 
          StyleBox[ 
            Cell[ 
              BoxData[ 
                FormBox[ 
                  SuperscriptBox[ "\[DoubleStruckCapitalR]", "n"], 
                  TraditionalForm]]]], ". Curvas"], "Header"]}, {Cell[ 
        TextData[ 
        "F. Javier P\[EAcute]rez Gonz\[AAcute]lez\nDpto. An\[AAcute]lisis \
Matem\[AAcute]tico - Universidad de Granada"], "Header"], Cell[ 
        TextData[ {
          CounterBox[ "Page"]}], "PageNumber"], Cell[ 
        TextData[ "Estructura eucl\[IAcute]dea de ", 
          StyleBox[ 
            Cell[ 
              BoxData[ 
                FormBox[ 
                  SuperscriptBox[ "\[DoubleStruckCapitalR]", "n"], 
                  TraditionalForm]]]], ". Curvas"], "Header"]}},
PrintingOptions->{"FirstPageHeader"->False,
"FacingPages"->True},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.32.1"->{
    Cell[55178, 1710, 57, 1, 71, "Input",
      CellTags->"S5.32.1"],
    Cell[55334, 1717, 58, 1, 71, "Input",
      CellTags->"S5.32.1"]},
  "S5.29.1"->{
    Cell[64518, 1936, 61, 1, 71, "Input",
      CellTags->"S5.29.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.32.1", 192343, 5567},
  {"S5.29.1", 192499, 5572}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 161, 5, 99, "Title"],
Cell[1918, 58, 180, 2, 102, "Author"],

Cell[CellGroupData[{
Cell[2123, 64, 39, 0, 93, "Section"],
Cell[2165, 66, 1145, 23, 197, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3347, 94, 139, 4, 93, "Section"],
Cell[3489, 100, 1298, 31, 183, "Text"],
Cell[4790, 133, 320, 7, 77, "Text"],
Cell[5113, 142, 1973, 50, 274, "Text"],
Cell[7089, 194, 239, 5, 72, "Text"],
Cell[7331, 201, 875, 23, 119, "Text"],
Cell[8209, 226, 1110, 35, 93, "Text"],

Cell[CellGroupData[{
Cell[9344, 265, 31, 0, 68, "Exercise"],
Cell[9378, 267, 830, 19, 153, "ExerciseText"],
Cell[10211, 288, 1078, 37, 93, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11326, 330, 31, 0, 68, "Exercise"],
Cell[11360, 332, 668, 15, 127, "ExerciseText"],
Cell[12031, 349, 1402, 41, 183, "Text"],
Cell[13436, 392, 261, 5, 72, "Text"],
Cell[13700, 399, 908, 35, 68, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14645, 439, 31, 0, 68, "Exercise"],
Cell[14679, 441, 627, 23, 75, "ExerciseText"],
Cell[15309, 466, 1210, 34, 95, "Text"],
Cell[16522, 502, 982, 29, 93, "Text"],
Cell[17507, 533, 235, 5, 77, "Text"],
Cell[17745, 540, 30, 0, 41, "Text"],
Cell[17778, 542, 182, 3, 72, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17997, 550, 31, 0, 68, "Exercise"],
Cell[18031, 552, 120, 4, 41, "ExerciseText"],
Cell[18154, 558, 392, 17, 41, "Text"],
Cell[18549, 577, 1532, 47, 121, "Text"],
Cell[20084, 626, 3636, 121, 161, "Text"],
Cell[23723, 749, 2019, 54, 40, "Text"],
Cell[25745, 805, 768, 24, 67, "Text"],
Cell[26516, 831, 2570, 68, 175, "Text"],
Cell[29089, 901, 732, 17, 119, "Text"],
Cell[29824, 920, 1257, 23, 141, "Text"],
Cell[31084, 945, 563, 17, 67, "Text"],
Cell[31650, 964, 383, 6, 76, "Text"],
Cell[32036, 972, 1260, 37, 119, "Text"],
Cell[33299, 1011, 568, 11, 119, "Text"],
Cell[33870, 1024, 415, 9, 166, "Input"],
Cell[34288, 1035, 490, 18, 67, "Text"],
Cell[34781, 1055, 1090, 23, 306, "Input"],
Cell[35874, 1080, 196, 5, 41, "Text"],
Cell[36073, 1087, 203, 4, 62, "Text"],
Cell[36279, 1093, 360, 12, 67, "Text"],
Cell[36642, 1107, 177, 4, 62, "Text"],
Cell[36822, 1113, 255, 8, 41, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37114, 1126, 139, 4, 78, "Subsection"],
Cell[37256, 1132, 339, 11, 41, "Text"],
Cell[37598, 1145, 456, 15, 41, "Text"],
Cell[38057, 1162, 224, 8, 41, "Text"],
Cell[38284, 1172, 458, 13, 35, "Text"],
Cell[38745, 1187, 1149, 35, 105, "Text"],
Cell[39897, 1224, 1378, 32, 58, "Text"],
Cell[41278, 1258, 102, 3, 41, "Text"],
Cell[41383, 1263, 1033, 26, 82, "Text"],
Cell[42419, 1291, 617, 20, 93, "Text"],
Cell[43039, 1313, 2358, 69, 201, "Text"],
Cell[45400, 1384, 105, 3, 41, "Text"],
Cell[45508, 1389, 989, 20, 63, "Text"],
Cell[46500, 1411, 729, 25, 67, "Text"],
Cell[47232, 1438, 688, 18, 46, "Text"],
Cell[47923, 1458, 198, 6, 41, "Text"],
Cell[48124, 1466, 213, 5, 124, "Input"],
Cell[48340, 1473, 309, 11, 41, "Text"],
Cell[48652, 1486, 683, 20, 68, "Text"],
Cell[49338, 1508, 972, 35, 93, "Text"],
Cell[50313, 1545, 311, 7, 256, "Input"],
Cell[50627, 1554, 4320, 148, 384, "Text"],
Cell[54950, 1704, 225, 4, 67, "Text"],
Cell[55178, 1710, 57, 1, 71, "Input",
  CellTags->"S5.32.1"],
Cell[55238, 1713, 93, 2, 41, "Text"],
Cell[55334, 1717, 58, 1, 71, "Input",
  CellTags->"S5.32.1"],
Cell[55395, 1720, 220, 4, 98, "Input"],
Cell[55618, 1726, 57, 0, 41, "Text"],
Cell[55678, 1728, 209, 3, 98, "Input"],
Cell[55890, 1733, 250, 5, 124, "Input"],
Cell[56143, 1740, 499, 15, 67, "Text"],
Cell[56645, 1757, 335, 6, 186, "Input"],
Cell[56983, 1765, 198, 4, 67, "Text"],
Cell[57184, 1771, 1317, 21, 514, "Input"],
Cell[58504, 1794, 168, 3, 67, "Text"],
Cell[58675, 1799, 664, 13, 236, "Input"],
Cell[59342, 1814, 921, 15, 332, "Input"],
Cell[60266, 1831, 205, 4, 124, "Input"],
Cell[60474, 1837, 706, 23, 93, "Text"],
Cell[61183, 1862, 1861, 32, 679, "Input"],

Cell[CellGroupData[{
Cell[63069, 1898, 31, 0, 68, "Exercise"],
Cell[63103, 1900, 424, 8, 109, "ExerciseText"],
Cell[63530, 1910, 105, 3, 41, "Text"],
Cell[63638, 1915, 233, 4, 124, "Input"],
Cell[63874, 1921, 641, 13, 306, "Input"],
Cell[64518, 1936, 61, 1, 71, "Input",
  CellTags->"S5.29.1"],
Cell[64582, 1939, 267, 5, 176, "Input"],
Cell[64852, 1946, 768, 25, 67, "Text"],
Cell[65623, 1973, 1621, 26, 566, "Input"],
Cell[67247, 2001, 383, 12, 67, "Text"],
Cell[67633, 2015, 1999, 37, 670, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[69669, 2057, 31, 0, 68, "Exercise"],
Cell[69703, 2059, 654, 20, 101, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[70394, 2084, 31, 0, 68, "Exercise"],
Cell[70428, 2086, 282, 8, 41, "ExerciseText"],
Cell[70713, 2096, 163, 3, 62, "Text"],
Cell[70879, 2101, 197, 5, 41, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[71137, 2113, 37, 0, 93, "Section"],
Cell[71177, 2115, 2496, 76, 310, "Text"],
Cell[73676, 2193, 1115, 31, 181, "Text"],
Cell[74794, 2226, 416, 7, 254, "Input"],
Cell[75213, 2235, 160, 3, 98, "Input"],
Cell[75376, 2240, 217, 4, 154, "Input"],
Cell[75596, 2246, 728, 22, 124, "Input"],
Cell[76327, 2270, 219, 4, 67, "Text"],
Cell[76549, 2276, 165, 3, 73, "Input"],

Cell[CellGroupData[{
Cell[76739, 2283, 67, 0, 78, "Subsection"],
Cell[76809, 2285, 148, 3, 41, "Text"],
Cell[76960, 2290, 3911, 115, 273, "Text"],
Cell[80874, 2407, 73, 0, 41, "Text"],
Cell[80950, 2409, 381, 7, 202, "Input"],
Cell[81334, 2418, 815, 15, 332, "Input"],
Cell[82152, 2435, 588, 14, 202, "Input"],
Cell[82743, 2451, 1895, 61, 173, "Text"],
Cell[84641, 2514, 500, 18, 67, "Text"],
Cell[85144, 2534, 291, 9, 62, "Text"],
Cell[85438, 2545, 622, 19, 67, "Text"],
Cell[86063, 2566, 577, 19, 62, "Text"],
Cell[86643, 2587, 79, 0, 41, "Text"],
Cell[86725, 2589, 224, 4, 160, "Input"],
Cell[86952, 2595, 585, 11, 228, "Input"],

Cell[CellGroupData[{
Cell[87562, 2610, 31, 0, 68, "Exercise"],
Cell[87596, 2612, 101, 2, 41, "ExerciseText"],
Cell[87700, 2616, 891, 28, 62, "Text"],
Cell[88594, 2646, 396, 12, 41, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[89027, 2663, 31, 0, 68, "Exercise"],
Cell[89061, 2665, 773, 19, 119, "ExerciseText"],
Cell[89837, 2686, 319, 5, 67, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[90193, 2696, 32, 0, 68, "Exercise"],
Cell[90228, 2698, 2229, 59, 247, "ExerciseText"],
Cell[92460, 2759, 1194, 38, 120, "Text"],
Cell[93657, 2799, 101, 1, 41, "Text"],
Cell[93761, 2802, 439, 12, 67, "Text"],
Cell[94203, 2816, 284, 4, 150, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[94548, 2827, 114, 3, 93, "Section"],
Cell[94665, 2832, 1107, 26, 131, "Text"],
Cell[95775, 2860, 508, 14, 35, "Text"],
Cell[96286, 2876, 1381, 37, 145, "Text"],
Cell[97670, 2915, 575, 11, 119, "Text"],
Cell[98248, 2928, 249, 5, 98, "Input"],
Cell[98500, 2935, 1381, 42, 145, "Text"],
Cell[99884, 2979, 476, 15, 67, "Text"],
Cell[100363, 2996, 291, 9, 62, "Text"],
Cell[100657, 3007, 1444, 46, 67, "Text"],

Cell[CellGroupData[{
Cell[102126, 3057, 32, 0, 68, "Exercise"],
Cell[102161, 3059, 190, 7, 41, "ExerciseText"],
Cell[102354, 3068, 149, 5, 41, "Text"],
Cell[102506, 3075, 577, 19, 62, "Text"],
Cell[103086, 3096, 248, 6, 41, "Text"],
Cell[103337, 3104, 205, 6, 41, "Text"],
Cell[103545, 3112, 1046, 35, 35, "Text"],
Cell[104594, 3149, 1662, 52, 67, "Text"],
Cell[106259, 3203, 1118, 22, 410, "Input"],
Cell[107380, 3227, 726, 22, 94, "Text"],
Cell[108109, 3251, 569, 16, 61, "Text"],
Cell[108681, 3269, 250, 8, 41, "Text"],
Cell[108934, 3279, 665, 19, 60, "Text"],
Cell[109602, 3300, 983, 26, 119, "Text"],
Cell[110588, 3328, 291, 7, 37, "Text"],
Cell[110882, 3337, 253, 11, 41, "Text"],
Cell[111138, 3350, 4247, 123, 271, "Text"],
Cell[115388, 3475, 773, 22, 93, "Text"],
Cell[116164, 3499, 4048, 109, 38, "Text"],
Cell[120215, 3610, 1192, 35, 41, "Text"],
Cell[121410, 3647, 3721, 96, 62, "Text"],
Cell[125134, 3745, 231, 6, 79, "Text"],
Cell[125368, 3753, 1394, 39, 38, "Text"],
Cell[126765, 3794, 3755, 111, 171, "Text"],
Cell[130523, 3907, 2558, 72, 197, "Text"],
Cell[133084, 3981, 124, 3, 41, "Text"],
Cell[133211, 3986, 2146, 56, 38, "Text"],
Cell[135360, 4044, 2129, 58, 40, "Text"],
Cell[137492, 4104, 24, 0, 41, "Text"],
Cell[137519, 4106, 1977, 53, 62, "Text"],
Cell[139499, 4161, 2130, 60, 62, "Text"],
Cell[141632, 4223, 185, 6, 42, "Text"],
Cell[141820, 4231, 974, 28, 62, "Text"],
Cell[142797, 4261, 118, 3, 41, "Text"],
Cell[142918, 4266, 440, 14, 40, "Text"],
Cell[143361, 4282, 58, 0, 41, "Text"],
Cell[143422, 4284, 676, 20, 36, "Text"],
Cell[144101, 4306, 52, 0, 41, "Text"],
Cell[144156, 4308, 107, 2, 61, "Text"],
Cell[144266, 4312, 59, 0, 41, "Text"],
Cell[144328, 4314, 474, 16, 65, "Text"],
Cell[144805, 4332, 2470, 71, 183, "Text"],
Cell[147278, 4405, 4162, 102, 70, "Text"],
Cell[151443, 4509, 568, 12, 93, "Text"],
Cell[152014, 4523, 1407, 38, 64, "Text"],
Cell[153424, 4563, 294, 8, 67, "Text"],
Cell[153721, 4573, 693, 23, 41, "Text"],
Cell[154417, 4598, 4215, 107, 70, "Text"],
Cell[158635, 4707, 1446, 48, 95, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[160118, 4760, 32, 0, 68, "Exercise"],
Cell[160153, 4762, 393, 7, 143, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[160583, 4774, 32, 0, 68, "Exercise"],
Cell[160618, 4776, 392, 7, 143, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[161047, 4788, 54, 0, 68, "Exercise"],
Cell[161104, 4790, 1642, 41, 290, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[162783, 4836, 32, 0, 68, "Exercise"],
Cell[162818, 4838, 915, 22, 161, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[163770, 4865, 32, 0, 68, "Exercise"],
Cell[163805, 4867, 607, 11, 93, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[164449, 4883, 32, 0, 68, "Exercise"],
Cell[164484, 4885, 1342, 32, 171, "ExerciseText"],
Cell[165829, 4919, 24183, 583, 168, 8527, 386, "GraphicsData", "PostScript", \
"Graphics"],
Cell[190015, 5504, 459, 12, 106, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

